/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.APIRegistryEvent;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractPerk {
    protected static final Random rand = new Random();
    public static final PerkCategory CATEGORY_BASE = new PerkCategory("base", TextFormatting.WHITE.toString());
    public static final PerkCategory CATEGORY_ROOT = new PerkCategory("root", TextFormatting.WHITE.toString());
    public static final PerkCategory CATEGORY_MAJOR = new PerkCategory("major", TextFormatting.WHITE.toString());
    public static final PerkCategory CATEGORY_KEY = new PerkCategory("key", TextFormatting.GOLD.toString());
    public static final PerkCategory CATEGORY_EPIPHANY = new PerkCategory("epiphany", TextFormatting.GOLD.toString());
    public static final PerkCategory CATEGORY_FOCUS = new PerkCategory("focus", TextFormatting.GOLD.toString());
    private final ResourceLocation registryName;
    protected final Point offset;
    private PerkCategory category = CATEGORY_BASE;
    private List<String> tooltipCache = null;
    private boolean cacheTooltip = true;
    protected String ovrUnlocalizedNamePrefix = null;
    private PerkTreePoint<? extends AbstractPerk> treePoint = null;

    public AbstractPerk(String name, int x, int y) {
        this.registryName = new ResourceLocation("astralsorcery", name.toLowerCase());
        this.offset = new Point(x, y);
    }

    public AbstractPerk(ResourceLocation name, int x, int y) {
        this.registryName = name;
        this.offset = new Point(x, y);
    }

    protected PerkTreePoint<? extends AbstractPerk> initPerkTreePoint() {
        return new PerkTreePoint<AbstractPerk>(this, this.getOffset());
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Point getOffset() {
        return this.offset;
    }

    public final PerkTreePoint<? extends AbstractPerk> getPoint() {
        if (this.treePoint == null) {
            this.treePoint = this.initPerkTreePoint();
        }
        return this.treePoint;
    }

    public <T> T setCategory(PerkCategory category) {
        this.category = category;
        return (T)this;
    }

    @Optional.Method(modid="crafttweaker")
    public final void adjustMultipliers() {
        double multiplier = hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.PerkTree.getMultiplier(this);
        this.applyEffectMultiplier(multiplier);
    }

    protected void applyEffectMultiplier(double multiplier) {
    }

    public boolean modifiersDisabled(EntityPlayer player, Side side) {
        APIRegistryEvent.PerkDisable event = new APIRegistryEvent.PerkDisable(this, player, side);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isPerkDisabled();
    }

    final void applyPerk(EntityPlayer player, Side side) {
        if (this.modifiersDisabled(player, side)) {
            return;
        }
        this.applyPerkLogic(player, side);
        if (PerkAttributeHelper.getOrCreateMap(player, side).markPerkApplied(this)) {
            LogCategory.PERKS.info(() -> "Cache: " + this.getRegistryName() + " applied!");
        }
    }

    final void removePerk(EntityPlayer player, Side side) {
        if (this.modifiersDisabled(player, side)) {
            return;
        }
        this.removePerkLogic(player, side);
        if (PerkAttributeHelper.getOrCreateMap(player, side).markPerkRemoved(this)) {
            LogCategory.PERKS.info(() -> "Cache: " + this.getRegistryName() + " removed!");
        }
    }

    protected abstract void applyPerkLogic(EntityPlayer var1, Side var2);

    protected abstract void removePerkLogic(EntityPlayer var1, Side var2);

    @Nullable
    public NBTTagCompound getPerkData(EntityPlayer player, Side side) {
        return ResearchManager.getProgress(player, side).getPerkData(this);
    }

    public void modifyPerkServer(EntityPlayer player, PlayerProgress progress, NBTTagCompound dataStorage) {
    }

    public void onUnlockPerkServer(@Nullable EntityPlayer player, PlayerProgress progress, NBTTagCompound dataStorage) {
    }

    public void onRemovePerkServer(EntityPlayer player, PlayerProgress progress, NBTTagCompound dataStorage) {
    }

    public <T> T setNameOverride(AbstractPerk other) {
        return this.setNameOverride(other.getTranslationKey());
    }

    public <T> T setNameOverride(String namePrefix) {
        this.ovrUnlocalizedNamePrefix = namePrefix;
        return (T)this;
    }

    @Nonnull
    public PerkCategory getCategory() {
        return this.category;
    }

    public PerkTreePoint.AllocationStatus getPerkStatus(@Nullable EntityPlayer player, Side side) {
        if (player == null) {
            return PerkTreePoint.AllocationStatus.UNALLOCATED;
        }
        PlayerProgress progress = ResearchManager.getProgress(player, side);
        if (!progress.isValid()) {
            return PerkTreePoint.AllocationStatus.UNALLOCATED;
        }
        if (progress.hasPerkUnlocked(this)) {
            return PerkTreePoint.AllocationStatus.ALLOCATED;
        }
        return this.mayUnlockPerk(progress, player) ? PerkTreePoint.AllocationStatus.UNLOCKABLE : PerkTreePoint.AllocationStatus.UNALLOCATED;
    }

    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        if (!progress.hasFreeAllocationPoint(player)) {
            return false;
        }
        for (AbstractPerk otherPerks : PerkTree.PERK_TREE.getConnectedPerks(this)) {
            if (!progress.hasPerkUnlocked(otherPerks)) continue;
            return true;
        }
        return false;
    }

    public String getTranslationKey() {
        if (this.ovrUnlocalizedNamePrefix != null) {
            return this.ovrUnlocalizedNamePrefix;
        }
        return "perk." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a();
    }

    protected void disableTooltipCaching() {
        this.cacheTooltip = false;
        this.tooltipCache = null;
    }

    @SideOnly(value=Side.CLIENT)
    public final Collection<String> getLocalizedTooltip() {
        if (this.cacheTooltip && this.tooltipCache != null) {
            return this.tooltipCache;
        }
        this.tooltipCache = Lists.newArrayList();
        String key = this.ovrUnlocalizedNamePrefix;
        if (this.modifiersDisabled((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT)) {
            this.tooltipCache.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.disabled", (Object[])new Object[0]));
        } else if (!(this instanceof ProgressGatedPerk) || ((ProgressGatedPerk)this).canSeeClient()) {
            this.tooltipCache.add(this.getCategory().getTextFormatting() + I18n.func_135052_a((String)(this.getTranslationKey() + ".name"), (Object[])new Object[0]));
            if (key == null) {
                key = "perk." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a();
            }
            int prevLength = this.tooltipCache.size();
            boolean shouldAdd = this.addLocalizedTooltip(this.tooltipCache);
            if (shouldAdd && prevLength != this.tooltipCache.size()) {
                this.tooltipCache.add("");
            }
            if (I18n.func_188566_a((String)(key + ".desc.1"))) {
                int count = 1;
                while (I18n.func_188566_a((String)(key + ".desc." + count))) {
                    this.tooltipCache.add(I18n.func_135052_a((String)(key + ".desc." + count), (Object[])new Object[0]));
                    ++count;
                }
                this.tooltipCache.add("");
            } else if (I18n.func_188566_a((String)(key + ".desc"))) {
                this.tooltipCache.add(I18n.func_135052_a((String)(key + ".desc"), (Object[])new Object[0]));
                this.tooltipCache.add("");
            }
        } else {
            this.tooltipCache.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.missing_progress", (Object[])new Object[0]));
        }
        return this.tooltipCache;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addLocalizedTooltip(Collection<String> tooltip) {
        return false;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Collection<String> getSource() {
        String modid = this.getRegistryName().func_110624_b();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (mod != null) {
            return Lists.newArrayList((Object[])new String[]{mod.getName()});
        }
        return null;
    }

    public void clearCaches(Side side) {
    }

    @SideOnly(value=Side.CLIENT)
    public void clearClientCaches() {
        this.tooltipCache = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AbstractPerk)) {
            return false;
        }
        AbstractPerk that = (AbstractPerk)o;
        return Objects.equals(this.getRegistryName(), that.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleMouseClick(GuiJournalPerkTree gui, int mouseX, int mouseY) {
        return false;
    }

    public static class PerkCategory {
        private final String unlocName;
        private String textFormatting;

        public PerkCategory(@Nonnull String unlocName, @Nonnull String formattingPrefix) {
            this.unlocName = unlocName;
            this.textFormatting = formattingPrefix;
        }

        public String getTranslationKey() {
            return this.unlocName;
        }

        public String getTextFormatting() {
            return this.textFormatting;
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public String getLocalizedName() {
            String str = "perk.category." + this.unlocName + ".name";
            if (I18n.func_188566_a((String)str)) {
                return I18n.func_135052_a((String)("perk.category." + this.unlocName + ".name"), (Object[])new Object[0]);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerkCategory that = (PerkCategory)o;
            return Objects.equals(this.unlocName, that.unlocName);
        }

        public int hashCode() {
            return Objects.hash(this.unlocName);
        }
    }
}

