/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class ConstellationRegistry {
    private static List<IMajorConstellation> majorConstellations = new LinkedList<IMajorConstellation>();
    private static List<IWeakConstellation> weakConstellations = new LinkedList<IWeakConstellation>();
    private static List<IMinorConstellation> minorConstellations = new LinkedList<IMinorConstellation>();
    private static List<IConstellationSpecialShowup> specialShowupConstellations = new LinkedList<IConstellationSpecialShowup>();
    private static List<IConstellation> generalConstellationList = new LinkedList<IConstellation>();

    public static <T extends IConstellation> void registerConstellation(T constellation) {
        if (constellation instanceof IWeakConstellation) {
            if (constellation instanceof IMajorConstellation) {
                majorConstellations.add((IMajorConstellation)constellation);
            }
            weakConstellations.add((IWeakConstellation)constellation);
        } else if (constellation instanceof IMinorConstellation) {
            minorConstellations.add((IMinorConstellation)constellation);
        } else {
            AstralSorcery.log.warn("Tried to register constellation that's neither minor nor major or weak: " + constellation.toString());
            AstralSorcery.log.warn("Skipping specific constellation registration...");
            throw new IllegalStateException("Tried to register non-minor, non-weak and non-major constellation.");
        }
        if (constellation instanceof IConstellationSpecialShowup) {
            specialShowupConstellations.add((IConstellationSpecialShowup)constellation);
        }
        generalConstellationList.add(constellation);
    }

    @Nullable
    public static IConstellation getConstellationByName(String name) {
        if (name == null) {
            return null;
        }
        for (IConstellation iConstellation : majorConstellations) {
            if (!iConstellation.getTranslationKey().equals(name)) continue;
            return iConstellation;
        }
        for (IConstellation iConstellation : weakConstellations) {
            if (!iConstellation.getTranslationKey().equals(name)) continue;
            return iConstellation;
        }
        for (IConstellation iConstellation : minorConstellations) {
            if (!iConstellation.getTranslationKey().equals(name)) continue;
            return iConstellation;
        }
        return null;
    }

    @Nullable
    public static IMajorConstellation getMajorConstellationByName(String name) {
        if (name == null) {
            return null;
        }
        for (IMajorConstellation c : majorConstellations) {
            if (!c.getTranslationKey().equals(name)) continue;
            return c;
        }
        return null;
    }

    public static List<IConstellation> resolve(List<String> constellationsAsStrings) {
        LinkedList<IConstellation> resolved = new LinkedList<IConstellation>();
        for (String s : constellationsAsStrings) {
            IConstellation c = ConstellationRegistry.getConstellationByName(s);
            if (c == null) continue;
            resolved.add(c);
        }
        return resolved;
    }

    public static List<IConstellationSpecialShowup> getSpecialShowupConstellations() {
        return Collections.unmodifiableList(specialShowupConstellations);
    }

    public static List<IWeakConstellation> getWeakConstellations() {
        return Collections.unmodifiableList(weakConstellations);
    }

    public static List<IMajorConstellation> getMajorConstellations() {
        return Collections.unmodifiableList(majorConstellations);
    }

    public static List<IMinorConstellation> getMinorConstellations() {
        return Collections.unmodifiableList(minorConstellations);
    }

    public static List<IConstellation> getAllConstellations() {
        return Collections.unmodifiableList(generalConstellationList);
    }

    public static int getConstellationId(IConstellation c) {
        List<IConstellation> allConstellations = ConstellationRegistry.getAllConstellations();
        return allConstellations.indexOf(c);
    }

    public static IConstellation getConstellationById(int id) {
        List<IConstellation> allConstellations = ConstellationRegistry.getAllConstellations();
        return allConstellations.get(id);
    }
}

