/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.ItemComparator;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LightOreTransmutations {
    public static Collection<Transmutation> mtTransmutations = new ArrayList<Transmutation>();
    private static Collection<Transmutation> registeredTransmutations = new ArrayList<Transmutation>();
    private static Collection<Transmutation> localFallback = new ArrayList<Transmutation>();

    public static void init() {
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_189877_df.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), 400.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150354_m.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), 400.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150482_ag.func_176223_P(), Blocks.field_150412_bA.func_176223_P(), 1000.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_189878_dg.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_180398_cJ.func_176223_P(), Blocks.field_150368_y.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150322_A.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150385_bj.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150366_p.func_176223_P(), BlocksAS.customOre.func_176223_P().func_177226_a(BlockCustomOre.ORE_TYPE, (Comparable)((Object)BlockCustomOre.OreType.STARMETAL)), 100.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150423_aK, Blocks.field_150414_aQ.func_176223_P(), new ItemStack(Blocks.field_150423_aK), new ItemStack(Items.field_151105_aU), 600.0));
        LightOreTransmutations.cacheLocalFallback();
    }

    private static void cacheLocalFallback() {
        if (localFallback.isEmpty()) {
            localFallback.addAll(registeredTransmutations);
        }
    }

    public static void loadFromFallback() {
        registeredTransmutations.clear();
        registeredTransmutations.addAll(localFallback);
    }

    public static Transmutation tryRemoveTransmutation(ItemStack outRemove, boolean matchMeta) {
        Block b = Block.func_149634_a((Item)outRemove.func_77973_b());
        if (b != Blocks.field_150350_a) {
            for (Transmutation tr : registeredTransmutations) {
                if (!tr.output.func_177230_c().equals(b) || matchMeta && tr.output.func_177230_c().func_176201_c(tr.output) != outRemove.func_77960_j()) continue;
                registeredTransmutations.remove(tr);
                return tr;
            }
        }
        for (Transmutation tr : registeredTransmutations) {
            if (tr.outStack.func_190926_b() || !ItemComparator.compare(tr.outStack, outRemove, ItemComparator.Clause.ITEM, ItemComparator.Clause.META_STRICT)) continue;
            registeredTransmutations.remove(tr);
            return tr;
        }
        return null;
    }

    @Nullable
    public static Transmutation registerTransmutation(Transmutation tr) {
        for (Transmutation t : registeredTransmutations) {
            if (!t.matchesInput(tr)) continue;
            AstralSorcery.log.warn("Tried to register Transmutation that has the same input as an already existing one.");
            return null;
        }
        if (!tr.hasValidInput()) {
            AstralSorcery.log.warn("Tried to register Transmutation with null input - Skipping!");
            return null;
        }
        if (tr.getInputAsBlock().equals(Blocks.field_150462_ai)) {
            AstralSorcery.log.warn("Cannot register Transmutation of workbench -> something. By default occupied by general crafting which is handled differently.");
            return null;
        }
        if (tr.output == null) {
            AstralSorcery.log.warn("Tried to register Transmutation with null output - Skipping!");
            return null;
        }
        registeredTransmutations.add(tr);
        return tr;
    }

    public static Collection<Transmutation> getRegisteredTransmutations() {
        return Collections.unmodifiableCollection(registeredTransmutations);
    }

    @Nullable
    public static Transmutation searchForTransmutation(IBlockState tryStateIn) {
        for (Transmutation tr : registeredTransmutations) {
            if (!tr.matchesInput(tryStateIn)) continue;
            return tr;
        }
        for (Transmutation tr : mtTransmutations) {
            if (!tr.matchesInput(tryStateIn)) continue;
            return tr;
        }
        return null;
    }

    private static enum MatchingType {
        STATE,
        BLOCK;

    }

    public static class Transmutation {
        private final MatchingType type;
        private final Block inBlock;
        private final IBlockState input;
        private final IBlockState output;
        private final double cost;
        @Nonnull
        private final ItemStack outStack;
        @Nonnull
        private final ItemStack inStack;
        private IWeakConstellation requiredType = null;

        public Transmutation(Block input, IBlockState output, double cost) {
            this(input, output, ItemStack.field_190927_a, ItemStack.field_190927_a, cost);
        }

        public Transmutation(Block input, IBlockState output, @Nonnull ItemStack inputDisplay, @Nonnull ItemStack outputDisplay, double cost) {
            this.type = MatchingType.BLOCK;
            this.input = null;
            this.inBlock = input;
            this.output = output;
            this.cost = cost;
            this.outStack = outputDisplay;
            this.inStack = inputDisplay;
        }

        public Transmutation(IBlockState input, IBlockState output, double cost) {
            this(input, output, ItemStack.field_190927_a, ItemStack.field_190927_a, cost);
        }

        public Transmutation(IBlockState input, IBlockState output, @Nonnull ItemStack inputDisplay, @Nonnull ItemStack outputDisplay, double cost) {
            this.type = MatchingType.STATE;
            this.inBlock = null;
            this.input = input;
            this.output = output;
            this.cost = cost;
            this.outStack = outputDisplay;
            this.inStack = inputDisplay;
        }

        public Transmutation setRequiredType(IWeakConstellation requiredType) {
            this.requiredType = requiredType;
            return this;
        }

        public IWeakConstellation getRequiredType() {
            return this.requiredType;
        }

        public Block getInputAsBlock() {
            switch (this.type) {
                case STATE: {
                    return this.input.func_177230_c();
                }
                case BLOCK: {
                    return this.inBlock;
                }
            }
            return Blocks.field_150350_a;
        }

        public boolean hasValidInput() {
            switch (this.type) {
                case STATE: {
                    return this.input != null && !this.input.func_177230_c().equals(Blocks.field_150350_a);
                }
                case BLOCK: {
                    return this.inBlock != null && !this.inBlock.equals(Blocks.field_150350_a);
                }
            }
            return false;
        }

        public boolean matchesInput(IBlockState state) {
            switch (this.type) {
                case STATE: {
                    return this.input.equals(state);
                }
                case BLOCK: {
                    return this.inBlock.equals(state.func_177230_c());
                }
            }
            return false;
        }

        public boolean matchesInput(Transmutation other) {
            switch (this.type) {
                case STATE: {
                    switch (other.type) {
                        case STATE: {
                            return this.input.equals(other.input);
                        }
                        case BLOCK: {
                            return this.input.func_177230_c().equals(other.inBlock);
                        }
                    }
                }
                case BLOCK: {
                    switch (other.type) {
                        case STATE: {
                            return this.inBlock.equals(other.input.func_177230_c());
                        }
                        case BLOCK: {
                            return this.inBlock.equals(other.inBlock);
                        }
                    }
                }
            }
            return false;
        }

        public boolean matchesOutput(IBlockState state) {
            return this.output.equals(state);
        }

        public IBlockState getOutput() {
            return this.output;
        }

        public double getCost() {
            return this.cost;
        }

        @Nonnull
        public ItemStack getInputDisplayStack() {
            if (!this.inStack.func_190926_b()) {
                return this.inStack.func_77946_l();
            }
            return ItemUtils.createBlockStack(this.input);
        }

        @Nonnull
        public ItemStack getOutputDisplayStack() {
            if (!this.outStack.func_190926_b()) {
                return this.outStack.func_77946_l();
            }
            return ItemUtils.createBlockStack(this.output);
        }
    }
}

