/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.entities.EntityLiquidSpark;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.ILiquidStarlightPowered;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LiquidStarlightChaliceHandler {
    public static boolean doFluidTransfer(@Nonnull TileEntity source, @Nonnull TileEntity target, @Nonnull FluidStack toTransfer) {
        if (target.func_145837_r() || source.func_145837_r()) {
            return false;
        }
        IFluidHandler targetHandler = null;
        if (target.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            targetHandler = (IFluidHandler)target.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        if (targetHandler == null) {
            return false;
        }
        if (targetHandler.fill(toTransfer, false) < toTransfer.amount) {
            return false;
        }
        World world = source.func_145831_w();
        EntityLiquidSpark spark = new EntityLiquidSpark(world, source.func_174877_v().func_177984_a(), target);
        spark.setFluidRepresented(toTransfer);
        world.func_72838_d((Entity)spark);
        return true;
    }

    public static boolean requestLiquidStarlightAndTransferTo(ILiquidStarlightPowered target, TileChalice source, int tileTicksExisted, int mbRequested) {
        FluidStack drained;
        if (!(target instanceof TileEntity) || tileTicksExisted % 100 != 0) {
            return false;
        }
        FluidStack expected = new FluidStack(BlocksAS.fluidLiquidStarlight, mbRequested);
        World world = ((TileEntity)target).func_145831_w();
        if (source.getTank() != null && source.getTank().getFluid() != null && source.getTank().getFluid().containsFluid(expected) && (drained = source.getTank().drain(expected, true)) != null) {
            source.markForUpdate();
            EntityLiquidSpark spark = new EntityLiquidSpark(world, source.func_174877_v().func_177984_a(), (TileEntity)target);
            spark.setFluidRepresented(new FluidStack(BlocksAS.fluidLiquidStarlight, drained.amount));
            world.func_72838_d((Entity)spark);
            return true;
        }
        return false;
    }

    public static boolean requestLiquidStarlightAndTransferTo(ILiquidStarlightPowered target, int tileTicksExisted, int mbRequested) {
        if (!(target instanceof TileEntity) || tileTicksExisted % 100 != 0) {
            return false;
        }
        Vector3 thisV = new Vector3(((TileEntity)target).func_174877_v()).add(0.5, 0.5, 0.5);
        FluidStack expected = new FluidStack(BlocksAS.fluidLiquidStarlight, mbRequested);
        World world = ((TileEntity)target).func_145831_w();
        int chX = ((TileEntity)target).func_174877_v().func_177958_n() >> 4;
        int chZ = ((TileEntity)target).func_174877_v().func_177952_p() >> 4;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                int cX = chX + xx;
                int cZ = chZ + zz;
                if (!world.func_175667_e(new BlockPos(cX * 16, 1, cZ * 16))) continue;
                Chunk ch = world.func_72964_e(cX, cZ);
                Map tiles = ch.func_177434_r();
                for (TileEntity te : tiles.values()) {
                    FluidStack drained;
                    TileChalice tc;
                    RaytraceAssist rta;
                    if (te.func_145837_r() || !(te instanceof TileChalice)) continue;
                    Vector3 vector3 = new Vector3(te.func_174877_v());
                    if (!(vector3.distance(thisV) <= 16.0) || world.func_175687_A(te.func_174877_v()) > 0 || !(rta = new RaytraceAssist(thisV, new Vector3((tc = (TileChalice)te).func_174877_v()).add(0.5, 0.5, 0.5))).isClear(world) || tc.getTank() == null || tc.getTank().getFluid() == null || !tc.getTank().getFluid().containsFluid(expected) || (drained = tc.getTank().drain(expected, true)) == null) continue;
                    tc.markForUpdate();
                    EntityLiquidSpark spark = new EntityLiquidSpark(world, tc.func_174877_v().func_177984_a(), (TileEntity)target);
                    spark.setFluidRepresented(new FluidStack(BlocksAS.fluidLiquidStarlight, drained.amount));
                    world.func_72838_d((Entity)spark);
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public static List<TileChalice> findNearbyChalicesWithSpaceFor(TileEntity origin, FluidStack stackExpectedToFit) {
        LinkedList<TileChalice> out = new LinkedList<TileChalice>();
        FluidStack expected = stackExpectedToFit.copy();
        Vector3 thisV = new Vector3(origin).add(0.5, 0.5, 0.5);
        World world = origin.func_145831_w();
        int chX = origin.func_174877_v().func_177958_n() >> 4;
        int chZ = origin.func_174877_v().func_177952_p() >> 4;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                int cX = chX + xx;
                int cZ = chZ + zz;
                if (!world.func_175667_e(new BlockPos(cX * 16, 1, cZ * 16))) continue;
                Chunk ch = world.func_72964_e(cX, cZ);
                Map tiles = ch.func_177434_r();
                for (TileEntity te : tiles.values()) {
                    TileChalice tc;
                    if (te.func_145837_r() || !(te instanceof TileChalice)) continue;
                    Vector3 vector3 = new Vector3(te.func_174877_v());
                    if (!(vector3.distance(thisV) <= 16.0) || world.func_175687_A(te.func_174877_v()) > 0 || (tc = (TileChalice)te).getTank() == null || !tc.getTank().canFillFluidType(expected) || tc.getTank().fill(expected, false) < expected.amount) continue;
                    out.add(tc);
                }
            }
        }
        Iterator iterator = out.iterator();
        while (iterator.hasNext()) {
            TileChalice tc = (TileChalice)iterator.next();
            RaytraceAssist rta = new RaytraceAssist(thisV, new Vector3(tc.func_174877_v()).add(0.5, 0.5, 0.5));
            if (rta.isClear(world)) continue;
            iterator.remove();
        }
        return out;
    }

    @Nonnull
    public static List<TileChalice> findNearbyChalicesThatContain(TileEntity origin, FluidStack expected) {
        LinkedList<TileChalice> out = new LinkedList<TileChalice>();
        expected = expected.copy();
        Vector3 thisV = new Vector3(origin).add(0.5, 0.5, 0.5);
        World world = origin.func_145831_w();
        int chX = origin.func_174877_v().func_177958_n() >> 4;
        int chZ = origin.func_174877_v().func_177952_p() >> 4;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                int cX = chX + xx;
                int cZ = chZ + zz;
                if (!world.func_175667_e(new BlockPos(cX * 16, 1, cZ * 16))) continue;
                Chunk ch = world.func_72964_e(cX, cZ);
                Map tiles = ch.func_177434_r();
                for (TileEntity te : tiles.values()) {
                    TileChalice tc;
                    if (te.func_145837_r() || !(te instanceof TileChalice)) continue;
                    Vector3 vector3 = new Vector3(te.func_174877_v());
                    if (!(vector3.distance(thisV) <= 16.0) || world.func_175687_A(te.func_174877_v()) > 0 || (tc = (TileChalice)te).getTank() == null || tc.getTank().getFluid() == null || !tc.getTank().getFluid().containsFluid(expected)) continue;
                    out.add(tc);
                }
            }
        }
        Iterator iterator = out.iterator();
        while (iterator.hasNext()) {
            TileChalice tc = (TileChalice)iterator.next();
            RaytraceAssist rta = new RaytraceAssist(thisV, new Vector3(tc.func_174877_v()).add(0.5, 0.5, 0.5));
            if (rta.isClear(world)) continue;
            iterator.remove();
        }
        return out;
    }
}

