/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky;

import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.mappings.ClientConstellationPositionMapping;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.CelestialEvent;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;

public class RenderAstralSkybox
extends IRenderHandler {
    private long worldSeed;
    private boolean initialized = false;
    private static final ResourceLocation MC_DEF_SUN_PNG = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation MC_DEF_MOON_PHASES_PNG = new ResourceLocation("textures/environment/moon_phases.png");
    public static final BindableResource TEX_STAR_1 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "star1");
    public static final BindableResource TEX_STAR_2 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "star2");
    public static final BindableResource TEX_STAR_3 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "star2");
    public static final BindableResource TEX_STAR_4 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "star1");
    public static final BindableResource TEX_CONNECTION = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
    public static final BindableResource TEX_SOLAR_ECLIPSE = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "solareclipse");
    private static int glSkyList = -1;
    private static int glSkyList2 = -1;
    private static final int[] starAmountMap = new int[]{200, 200, 100, 100, 100, 200, 100, 50, 50, 100, 50, 50, 100, 100, 100, 50, 50, 100, 100, 100};
    private static final double[] starSizeMap = new double[]{1.0, 1.0, 1.0, 1.2, 1.0, 1.0, 1.1, 1.2, 1.0, 1.0, 1.2, 1.1, 1.0, 1.0, 1.0, 1.2, 1.3, 1.0, 1.0, 1.0};
    private static StarDList[] starLists = new StarDList[0];

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (!this.isInitialized()) {
            return;
        }
        this.renderSky(partialTicks);
    }

    public void refreshRender() {
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(long worldSeed) {
        this.worldSeed = worldSeed;
        this.setupSkybox();
        this.setupStarVertices();
        this.initialized = true;
    }

    private void setupStarVertices() {
        this.cleanStarVertices();
        starLists = new StarDList[20];
        for (int i = 0; i < starLists.length; ++i) {
            RenderAstralSkybox.starLists[i] = new StarDList();
        }
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        Random vRand = new Random(this.worldSeed);
        int list = GLAllocation.func_74526_a((int)20);
        for (int i = 0; i < starLists.length; ++i) {
            StarDList l = starLists[i];
            l.glList = list + i;
            l.sinDivisor = 10 + vRand.nextInt(15);
            switch (i / (starLists.length / 4)) {
                case 0: {
                    l.resource = RenderAstralSkybox.TEX_STAR_1;
                    break;
                }
                case 1: {
                    l.resource = RenderAstralSkybox.TEX_STAR_2;
                    break;
                }
                case 2: {
                    l.resource = RenderAstralSkybox.TEX_STAR_3;
                    break;
                }
                case 3: {
                    l.resource = RenderAstralSkybox.TEX_STAR_4;
                    break;
                }
            }
            GlStateManager.func_187423_f((int)l.glList, (int)4864);
            l.resource.bind();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.setupStars(vb, vRand, starAmountMap[i], starSizeMap[i]);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void cleanStarVertices() {
        for (StarDList list : starLists) {
            if (list.glList == -1) continue;
            GLAllocation.func_74523_b((int)list.glList);
            list.glList = -1;
        }
    }

    private void setupStars(BufferBuilder vb, Random random, int amount, double multiplier) {
        for (int i = 0; i < amount; ++i) {
            double x = random.nextFloat() * 2.0f - 1.0f;
            double y = random.nextFloat() * 2.0f - 1.0f;
            double z = random.nextFloat() * 2.0f - 1.0f;
            double ovrSize = 0.15f + random.nextFloat() * 0.2f;
            double d4 = x * x + y * y + z * z;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (x *= d4) * 100.0;
            double d6 = (y *= d4) * 100.0;
            double d7 = (z *= d4) * 100.0;
            double d8 = Math.atan2(x, z);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(x * x + z * z), y);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double size = Math.sin(d14) * 2.0;
            double d16 = Math.cos(d14);
            size *= multiplier;
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * ovrSize;
                double d19 = (double)((j + 1 & 2) - 1) * ovrSize;
                double d21 = d18 * d16 - d19 * size;
                double d22 = d19 * d16 + d18 * size;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                vb.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_187315_a((double)((j + 1 & 2) >> 1), (double)((j + 2 & 2) >> 1)).func_181675_d();
            }
        }
    }

    private void setupSkybox() {
        if (glSkyList >= 0) {
            GLAllocation.func_74523_b((int)glSkyList);
            glSkyList = -1;
        }
        glSkyList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)glSkyList, (int)4864);
        this.setupBackground(false);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_187415_K();
        if (glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)glSkyList2);
            glSkyList2 = -1;
        }
        glSkyList2 = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)glSkyList2, (int)4864);
        this.setupBackground(true);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_187415_K();
    }

    private void setupBackground(boolean invert) {
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float px = k + 64;
                float p = k;
                if (invert) {
                    px = k;
                    p = k + 64;
                }
                vb.func_181662_b((double)p, 16.0, (double)l).func_181675_d();
                vb.func_181662_b((double)px, 16.0, (double)l).func_181675_d();
                vb.func_181662_b((double)px, 16.0, (double)(l + 64)).func_181675_d();
                vb.func_181662_b((double)p, 16.0, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void renderSky(float partialTicks) {
        GlStateManager.func_179090_x();
        Vec3d vec3 = Minecraft.func_71410_x().field_71441_e.func_72833_a(Minecraft.func_71410_x().func_175606_aa(), partialTicks);
        float f = (float)vec3.field_72450_a;
        float f1 = (float)vec3.field_72448_b;
        float f2 = (float)vec3.field_72449_c;
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        GlStateManager.func_179148_o((int)glSkyList);
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] sunsetColors = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76560_a(Minecraft.func_71410_x().field_71441_e.func_72826_c(partialTicks), partialTicks);
        if (sunsetColors != null) {
            this.renderSunsetToBackground(sunsetColors, partialTicks);
        }
        this.renderDefaultCelestials(partialTicks);
        double absPlayerHorizon = Minecraft.func_71410_x().field_71439_g.func_174824_e((float)partialTicks).field_72448_b - Minecraft.func_71410_x().field_71441_e.func_72919_O();
        if (absPlayerHorizon < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            GlStateManager.func_179148_o((int)glSkyList2);
            GlStateManager.func_179121_F();
        }
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(absPlayerHorizon - 16.0))), (float)0.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void renderDefaultCelestials(float partialTicks) {
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float alphaSubRain = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaSubRain);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(Minecraft.func_71410_x().field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        if (handle != null && handle.getCurrentlyActiveEvent() == CelestialEvent.SOLAR_ECLIPSE) {
            this.renderSolarEclipseSun(handle);
        } else {
            this.renderSun();
        }
        if (handle != null && handle.getCurrentlyActiveEvent() == CelestialEvent.LUNAR_ECLIPSE) {
            int eclTick = handle.lunarEclipseTick;
            eclTick = eclTick >= ConstellationSkyHandler.getLunarEclipseHalfDuration() ? (eclTick -= ConstellationSkyHandler.getLunarEclipseHalfDuration()) : ConstellationSkyHandler.getLunarEclipseHalfDuration() - eclTick;
            float perc = (float)eclTick / (float)ConstellationSkyHandler.getLunarEclipseHalfDuration();
            GlStateManager.func_179131_c((float)1.0f, (float)(0.4f + 0.6f * perc), (float)(0.4f + 0.6f * perc), (float)alphaSubRain);
            this.renderMoon();
        } else {
            this.renderMoon();
        }
        this.renderStars((World)Minecraft.func_71410_x().field_71441_e, partialTicks);
        RenderAstralSkybox.renderConstellations((World)Minecraft.func_71410_x().field_71441_e, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
    }

    private void renderSolarEclipseSun(WorldSkyHandler handle) {
        double xzSize = 30.0;
        float part = (float)ConstellationSkyHandler.getSolarEclipseHalfDuration() * 2.0f / 7.0f;
        float u = 0.0f;
        float tick = handle.solarEclipseTick;
        while (tick - part > 0.0f) {
            tick -= part;
            u += 1.0f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        TEX_SOLAR_ECLIPSE.bind();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(-xzSize, 100.0, -xzSize).func_187315_a((double)(u / 7.0f), 0.0).func_181675_d();
        vb.func_181662_b(xzSize, 100.0, -xzSize).func_187315_a((double)((u + 1.0f) / 7.0f), 0.0).func_181675_d();
        vb.func_181662_b(xzSize, 100.0, xzSize).func_187315_a((double)((u + 1.0f) / 7.0f), 1.0).func_181675_d();
        vb.func_181662_b(-xzSize, 100.0, xzSize).func_187315_a((double)(u / 7.0f), 1.0).func_181675_d();
        tessellator.func_78381_a();
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
    }

    public static void renderConstellationsWrapped(World w, float pticks) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float alphaSubRain = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(pticks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaSubRain);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(Minecraft.func_71410_x().field_71441_e.func_72826_c(pticks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        RenderAstralSkybox.renderConstellations(w, pticks);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
    }

    private static void renderConstellations(final World w, final float partialTicks) {
        ClientConstellationPositionMapping mapping;
        long wTime = (w.func_72820_D() % (long)Config.dayLength + (long)Config.dayLength) % (long)Config.dayLength;
        if ((float)wTime < (float)Config.dayLength / 2.0f) {
            return;
        }
        float rainDim = 1.0f - w.func_72867_j(partialTicks);
        final float brightness = w.func_72880_h(partialTicks) * rainDim;
        if (brightness <= 0.0f) {
            return;
        }
        final Random flRand = new Random(w.func_72905_C());
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(w);
        if (handle != null && (mapping = handle.getConstellationPositionMapping()) != null) {
            Map<IConstellation, ClientConstellationPositionMapping.RenderPosition> renderMap = mapping.getCurrentRenderPositions();
            for (Map.Entry<IConstellation, ClientConstellationPositionMapping.RenderPosition> entry : renderMap.entrySet()) {
                IConstellation c = entry.getKey();
                if (!ResearchManager.clientProgress.hasConstellationDiscovered(c.getTranslationKey()) || !handle.isActive(c)) continue;
                RenderConstellation.renderConstellation(c, entry.getValue(), new RenderConstellation.BrightnessFunction(){

                    @Override
                    public float getBrightness() {
                        return RenderConstellation.conCFlicker(w.func_72820_D(), partialTicks, 5 + flRand.nextInt(10)) * (2.0f * brightness);
                    }
                });
            }
        }
    }

    private void renderMoon() {
        double xzSize = 20.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MC_DEF_MOON_PHASES_PNG);
        int i = Minecraft.func_71410_x().field_71441_e.func_72853_d();
        int k = i % 4;
        int i1 = i / 4 % 2;
        float maxU = (float)k / 4.0f;
        float maxV = (float)i1 / 2.0f;
        float minU = (float)(k + 1) / 4.0f;
        float minV = (float)(i1 + 1) / 2.0f;
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(-xzSize, -100.0, xzSize).func_187315_a((double)minU, (double)minV).func_181675_d();
        vb.func_181662_b(xzSize, -100.0, xzSize).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vb.func_181662_b(xzSize, -100.0, -xzSize).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        vb.func_181662_b(-xzSize, -100.0, -xzSize).func_187315_a((double)minU, (double)maxV).func_181675_d();
        tessellator.func_78381_a();
    }

    private void renderSun() {
        double xzSize = 30.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MC_DEF_SUN_PNG);
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(-xzSize, 100.0, -xzSize).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b(xzSize, 100.0, -xzSize).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(xzSize, 100.0, xzSize).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(-xzSize, 100.0, xzSize).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private void renderStars(World w, float partialTicks) {
        float rainDim = 1.0f - w.func_72867_j(partialTicks);
        float brightness = w.func_72880_h(partialTicks) * rainDim;
        TextureHelper.refreshTextureBindState();
        if (brightness > 0.0f) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            for (StarDList list : starLists) {
                if (list.glList <= 0) continue;
                float sinBr = RenderConstellation.stdFlicker(w.func_72820_D(), partialTicks, list.sinDivisor) - brightness;
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)(sinBr < 0.0f ? 0.0f : sinBr));
                list.resource.bind();
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.func_179148_o((int)list.glList);
                tes.func_78381_a();
                TextureHelper.refreshTextureBindState();
            }
        }
    }

    private void renderSunsetToBackground(float[] sunsetColors, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)Minecraft.func_71410_x().field_71441_e.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f6 = sunsetColors[0];
        float f7 = sunsetColors[1];
        float f8 = sunsetColors[2];
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
            float f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
            float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
            f6 = f9;
            f7 = f10;
            f8 = f11;
        }
        vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        vb.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, sunsetColors[3]).func_181675_d();
        for (int l = 0; l <= 16; ++l) {
            float f21 = (float)l * (float)Math.PI * 2.0f / 16.0f;
            float f12 = MathHelper.func_76126_a((float)f21);
            float f13 = MathHelper.func_76134_b((float)f21);
            vb.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * sunsetColors[3])).func_181666_a(sunsetColors[0], sunsetColors[1], sunsetColors[2], 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179103_j((int)7424);
    }

    private static class StarDList {
        private int glList = -1;
        private BindableResource resource;
        private int sinDivisor = 1;

        private StarDList() {
        }
    }
}

