/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageConstellationRecipe;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class JournalPageTraitRecipe
implements IJournalPage {
    public TraitRecipe recipe;

    public JournalPageTraitRecipe(TraitRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.recipe, TileAltar.AltarLevel.TRAIT_CRAFT);
    }

    public static class Render
    extends JournalPageConstellationRecipe.Render {
        private static final BindableResource texGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridtr");
        private final TraitRecipe recipe;

        public Render(TraitRecipe recipe, TileAltar.AltarLevel altarLevel) {
            super(recipe, altarLevel);
            this.recipe = recipe;
            this.gridTexture = texGrid;
        }

        private void renderTraitInnerSlots(float offsetX, float offsetY, float zLevel, TraitRecipe recipe) {
            RenderHelper.func_74520_c();
            this.renderAltarSlot(offsetX + 80.0f, offsetY + 78.0f, zLevel, recipe.getInnerTraitItems(TraitRecipe.TraitRecipeSlot.UPPER_CENTER));
            this.renderAltarSlot(offsetX + 30.0f, offsetY + 128.0f, zLevel, recipe.getInnerTraitItems(TraitRecipe.TraitRecipeSlot.LEFT_CENTER));
            this.renderAltarSlot(offsetX + 131.0f, offsetY + 128.0f, zLevel, recipe.getInnerTraitItems(TraitRecipe.TraitRecipeSlot.RIGHT_CENTER));
            this.renderAltarSlot(offsetX + 80.0f, offsetY + 178.0f, zLevel, recipe.getInnerTraitItems(TraitRecipe.TraitRecipeSlot.LOWER_CENTER));
            RenderHelper.func_74518_a();
            TextureHelper.refreshTextureBindState();
        }

        private void renderTraitOuterSlots(float offsetX, float offsetY, float zLevel, TraitRecipe recipe) {
            RenderHelper.func_74520_c();
            float centerX = offsetX + 80.0f;
            float centerY = offsetY + 128.0f;
            float perc = (float)(ClientScheduler.getClientTick() % 3000L) / 3000.0f;
            zLevel += 100.0f;
            List<ItemHandle> traitItemHandles = recipe.getTraitItemHandles();
            int amt = traitItemHandles.size();
            for (int i = 0; i < amt; ++i) {
                ItemHandle handle = traitItemHandles.get(i);
                double part = (double)i / (double)amt * 2.0 * Math.PI;
                part = MathHelper.func_151237_a((double)part, (double)0.0, (double)(Math.PI * 2));
                double xAdd = Math.sin(part += Math.PI * 2 * (double)perc + Math.PI) * 75.0;
                double yAdd = Math.cos(part) * 75.0;
                this.renderRotatingSlot((float)((double)centerX + xAdd), (float)((double)centerY + yAdd), zLevel, (List<ItemStack>)handle.getApplicableItems());
            }
            RenderHelper.func_74518_a();
            TextureHelper.refreshTextureBindState();
        }

        private void renderRotatingSlot(float offsetX, float offsetY, float zLevel, List<ItemStack> stacks) {
            if (stacks == null || stacks.isEmpty()) {
                return;
            }
            long select = ClientScheduler.getClientTick() / 20L;
            ItemStack draw = stacks.get((int)(select %= (long)stacks.size()));
            TextureHelper.refreshTextureBindState();
            GL11.glPushMatrix();
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)(zLevel + 60.0f));
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            Rectangle r = this.drawItemStack(draw, 0, 0, 0.0f);
            r = new Rectangle((int)offsetX, (int)offsetY, (int)(r.getWidth() * 1.1), (int)(r.getHeight() * 1.1));
            this.addRenderedStackRectangle(r, draw);
            GL11.glPopMatrix();
        }

        @Override
        public void addTooltip(List<String> out) {
            super.addTooltip(out);
            if (this.recipe.getRequiredConstellation() != null) {
                out.add(I18n.func_135052_a((String)"astralsorcery.journal.recipe.constellation", (Object[])new Object[]{I18n.func_135052_a((String)this.recipe.getRequiredConstellation().getTranslationKey(), (Object[])new Object[0])}));
            }
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            super.render(offsetX, offsetY, pTicks, zLevel, mouseX, mouseY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderTraitInnerSlots(offsetX, offsetY, zLevel, this.recipe);
            this.renderTraitOuterSlots(offsetX, offsetY, zLevel, this.recipe);
            if (this.recipe.getRequiredConstellation() != null) {
                IConstellation focus = this.recipe.getRequiredConstellation();
                GlStateManager.func_179118_c();
                RenderConstellation.renderConstellationIntoGUI(new Color(0xEEEEEE), focus, Math.round(offsetX + 30.0f), Math.round(offsetY + 78.0f), zLevel, 125, 125, 2.0, new RenderConstellation.BrightnessFunction(){

                    @Override
                    public float getBrightness() {
                        return 0.3f;
                    }
                }, true, false);
                GlStateManager.func_179141_d();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

