/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageTraitRecipe;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.MoonPhaseRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.CapeAttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationPaperRecipe;
import hellfirepvp.astralsorcery.common.data.research.EnumGatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.RecipesAS;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiJournalConstellationDetails
extends GuiScreenJournal {
    private static final BindableResource texBlack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MISC, "black");
    private static final BindableResource texBg = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbgcst");
    private static final BindableResource texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijarrow");
    private IConstellation constellation;
    private GuiJournalConstellationCluster origin;
    private boolean detailed;
    private int doublePageID = 0;
    private int doublePages = 0;
    private IGuiRenderablePage lastFramePage = null;
    private Rectangle rectBack;
    private Rectangle rectNext;
    private Rectangle rectPrev;
    private List<MoonPhase> phases = new LinkedList<MoonPhase>();
    private List<MoonPhase> activePhases = new LinkedList<MoonPhase>();
    private List<String> locTextMain = new LinkedList<String>();
    private List<String> locTextRitualEnch = new LinkedList<String>();
    private List<String> locTextCapeEffect = new LinkedList<String>();

    public GuiJournalConstellationDetails(GuiJournalConstellationCluster origin, IConstellation c) {
        super(-1);
        this.origin = origin;
        this.constellation = c;
        boolean has = false;
        for (String strConstellation : ResearchManager.clientProgress.getKnownConstellations()) {
            IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
            if (ce == null || !ce.equals(c)) continue;
            has = true;
            break;
        }
        this.detailed = has;
        ProgressionTier playerProgress = ResearchManager.clientProgress.getTierReached();
        if (has && (EnumGatedKnowledge.CONSTELLATION_RITUAL.canSee(playerProgress) || EnumGatedKnowledge.CONSTELLATION_ENCH_POTION.canSee(playerProgress))) {
            ++this.doublePages;
            if (EnumGatedKnowledge.CONSTELLATION_CAPE.canSee(playerProgress) && !(this.constellation instanceof IMinorConstellation)) {
                ++this.doublePages;
            }
        }
        this.testPhases();
        this.testActivePhases();
        this.buildMainText();
        this.buildEnchText();
        this.buildRitualText();
        this.buildCapeText();
    }

    public IConstellation getConstellation() {
        return this.constellation;
    }

    private void buildCapeText() {
        String textEnch;
        String unlocEnch;
        if (EnumGatedKnowledge.CONSTELLATION_CAPE.canSee(ResearchManager.clientProgress.getTierReached()) && !(unlocEnch = this.constellation.getTranslationKey() + ".capeeffect").equals(textEnch = I18n.func_135052_a((String)unlocEnch, (Object[])new Object[0]))) {
            String head = I18n.func_135052_a((String)"gui.journal.cst.capeeffect", (Object[])new Object[0]);
            this.locTextCapeEffect.add(head);
            this.locTextCapeEffect.add("");
            LinkedList<String> lines = new LinkedList<String>();
            for (String segment : textEnch.split("<NL>")) {
                lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
                lines.add("");
            }
            this.locTextCapeEffect.addAll(lines);
            this.locTextCapeEffect.add("");
        }
    }

    private void buildEnchText() {
        String textEnch;
        String unlocEnch;
        if (EnumGatedKnowledge.CONSTELLATION_ENCH_POTION.canSee(ResearchManager.clientProgress.getTierReached()) && !(unlocEnch = this.constellation.getTranslationKey() + ".enchantments").equals(textEnch = I18n.func_135052_a((String)unlocEnch, (Object[])new Object[0]))) {
            String head = I18n.func_135052_a((String)"gui.journal.cst.enchantments", (Object[])new Object[0]);
            this.locTextRitualEnch.add(head);
            this.locTextRitualEnch.add("");
            LinkedList<String> lines = new LinkedList<String>();
            for (String segment : textEnch.split("<NL>")) {
                lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
                lines.add("");
            }
            this.locTextRitualEnch.addAll(lines);
            this.locTextRitualEnch.add("");
        }
    }

    private void buildRitualText() {
        if (EnumGatedKnowledge.CONSTELLATION_RITUAL.canSee(ResearchManager.clientProgress.getTierReached())) {
            if (this.constellation instanceof IMinorConstellation) {
                String textRitual;
                String unlocRitual = this.constellation.getTranslationKey() + ".trait";
                if (!unlocRitual.equals(textRitual = I18n.func_135052_a((String)unlocRitual, (Object[])new Object[0]))) {
                    String head = I18n.func_135052_a((String)"gui.journal.cst.ritual.trait", (Object[])new Object[0]);
                    this.locTextRitualEnch.add(head);
                    this.locTextRitualEnch.add("");
                    LinkedList<String> lines = new LinkedList<String>();
                    for (String segment : textRitual.split("<NL>")) {
                        lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
                        lines.add("");
                    }
                    this.locTextRitualEnch.addAll(lines);
                }
            } else {
                String textRitual;
                String unlocRitual = this.constellation.getTranslationKey() + ".ritual";
                if (!unlocRitual.equals(textRitual = I18n.func_135052_a((String)unlocRitual, (Object[])new Object[0]))) {
                    String head = I18n.func_135052_a((String)"gui.journal.cst.ritual", (Object[])new Object[0]);
                    this.locTextRitualEnch.add(head);
                    this.locTextRitualEnch.add("");
                    LinkedList<String> lines = new LinkedList<String>();
                    for (String segment : textRitual.split("<NL>")) {
                        lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
                        lines.add("");
                    }
                    this.locTextRitualEnch.addAll(lines);
                }
            }
        }
    }

    private void buildMainText() {
        String text;
        String unloc = this.constellation.getTranslationKey() + ".effect";
        if (unloc.equals(text = I18n.func_135052_a((String)unloc, (Object[])new Object[0]))) {
            return;
        }
        LinkedList<String> lines = new LinkedList<String>();
        for (String segment : text.split("<NL>")) {
            lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
            lines.add("");
        }
        this.locTextMain.addAll(lines);
    }

    private void testPhases() {
        Collections.addAll(this.phases, MoonPhase.values());
    }

    private void testActivePhases() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        WorldSkyHandler handler = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        if (handler == null) {
            return;
        }
        for (MoonPhase phase : this.phases) {
            List<IConstellation> active = handler.getConstellationsForMoonPhase(phase);
            if (active == null || active.isEmpty() || !active.contains(this.constellation)) continue;
            this.activePhases.add(phase);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.lastFramePage = null;
        Point mouse = new Point(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        switch (this.doublePageID) {
            case 0: {
                this.drawCstBackground();
                this.drawDefault(textureResShellCst, mouse);
                break;
            }
            case 1: {
                this.drawDefault(textureResBlank, mouse);
                break;
            }
            case 2: {
                this.drawDefault(textureResBlank, mouse);
                break;
            }
        }
        TextureHelper.refreshTextureBindState();
        this.field_73735_i += 150.0f;
        this.drawArrows(partialTicks, mouse);
        this.drawNavArrows(partialTicks, mouse);
        switch (this.doublePageID) {
            case 0: {
                this.drawConstellation(partialTicks);
                this.drawPhaseInformation();
                this.drawExtendedInformation();
                break;
            }
            case 1: {
                this.drawERPInformationPages(partialTicks, mouseX, mouseY);
                break;
            }
            case 2: {
                this.drawCapeInformationPages(partialTicks, mouseX, mouseY);
                break;
            }
        }
        this.field_73735_i -= 150.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawCapeInformationPages(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)0.86f, (float)0.86f, (float)0.86f, (float)0.8f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 30), (float)(this.guiTop + 30), (float)0.0f);
        for (int i = 0; i < this.locTextCapeEffect.size(); ++i) {
            String line = this.locTextCapeEffect.get(i);
            this.field_146289_q.func_175065_a(line, 0.0f, (float)(i * 10), 0xDDDDDD, true);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CapeAttunementRecipe recipe = RecipesAS.capeCraftingRecipes.get(this.constellation);
        if (recipe != null) {
            this.lastFramePage = new JournalPageTraitRecipe(recipe).buildRenderPage();
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)1048575);
            this.lastFramePage.render(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            this.lastFramePage.postRender(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
        }
    }

    private void drawERPInformationPages(float partialTicks, int mouseX, int mouseY) {
        ConstellationPaperRecipe recipe;
        ProgressionTier prog = ResearchManager.clientProgress.getTierReached();
        GlStateManager.func_179131_c((float)0.86f, (float)0.86f, (float)0.86f, (float)0.8f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 30), (float)(this.guiTop + 30), (float)0.0f);
        for (int i = 0; i < this.locTextRitualEnch.size(); ++i) {
            String line = this.locTextRitualEnch.get(i);
            this.field_146289_q.func_175065_a(line, 0.0f, (float)(i * 10), 0xDDDDDD, true);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (EnumGatedKnowledge.CONSTELLATION_ENCH_POTION.canSee(prog) && (recipe = RecipesAS.paperCraftingRecipes.get(this.constellation)) != null) {
            this.lastFramePage = new JournalPageTraitRecipe(recipe).buildRenderPage();
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)1048575);
            this.lastFramePage.render(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            this.lastFramePage.postRender(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
        }
    }

    private void drawNavArrows(float partialTicks, Point mouse) {
        float sin;
        double t;
        float vFrom;
        float uFrom;
        int height;
        int width;
        GlStateManager.func_179097_i();
        this.rectNext = null;
        this.rectPrev = null;
        if (this.doublePageID - 1 >= 0) {
            width = 30;
            height = 15;
            this.rectPrev = new Rectangle(this.guiLeft + 25, this.guiTop + 220, width, height);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.rectPrev.getX() + (double)(width / 2)), (double)(this.rectPrev.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            vFrom = 0.5f;
            if (this.rectPrev.contains(mouse)) {
                uFrom = 0.5f;
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GlStateManager.func_179121_F();
        }
        if (this.doublePageID + 1 <= this.doublePages) {
            width = 30;
            height = 15;
            this.rectNext = new Rectangle(this.guiLeft + 367, this.guiTop + 220, width, height);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.rectNext.getX() + (double)(width / 2)), (double)(this.rectNext.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            vFrom = 0.0f;
            if (this.rectNext.contains(mouse)) {
                uFrom = 0.5f;
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    private void drawCstBackground() {
        texBlack.bind();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder bb = tes.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b((double)(this.guiLeft + 15), (double)(this.guiTop + 240), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 200), (double)(this.guiTop + 240), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 200), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 15), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)1.0f, (float)0.7f);
        texBg.bind();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b((double)(this.guiLeft + 35), (double)(this.guiTop + this.guiHeight - 10), (double)this.field_73735_i).func_187315_a(0.3, 0.9).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35 + 170), (double)(this.guiTop + this.guiHeight - 10), (double)this.field_73735_i).func_187315_a(0.7, 0.9).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35 + 170), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.7, 0.1).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.3, 0.1).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawExtendedInformation() {
        float br = 0.8666f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        String info = I18n.func_135052_a((String)this.constellation.getUnlocalizedInfo(), (Object[])new Object[0]).toUpperCase();
        info = this.detailed ? info : "???";
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(info);
        double chX = 305.0 - width / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + chX), (double)(this.guiTop + 44), (double)0.0);
        fr.func_175065_a(info, 0.0f, 0.0f, -857874979, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        if (this.detailed && !this.locTextMain.isEmpty()) {
            int offsetX = 220;
            int offsetY = 77;
            for (String s : this.locTextMain) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179109_b((float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY), (float)0.0f);
                fr.func_175065_a(s, 0.0f, 0.0f, -857874979, true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
                TextureHelper.refreshTextureBindState();
                offsetY += 13;
            }
        }
    }

    private void drawPhaseInformation() {
        if (this.phases.isEmpty()) {
            this.testPhases();
            this.testActivePhases();
            if (this.phases.isEmpty()) {
                return;
            }
        }
        if (this.constellation instanceof IConstellationSpecialShowup) {
            GlStateManager.func_179097_i();
            double scale = 1.8;
            TextureHelper.refreshTextureBindState();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            double length = (double)fr.func_78256_a("? ? ?") * scale;
            double offsetLeft = (double)(this.guiLeft + 296) - length / 2.0;
            int offsetTop = this.guiTop + 199;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(offsetLeft + 10.0), (double)offsetTop, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            fr.func_175063_a("? ? ?", 0.0f, 0.0f, -857874979);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GlStateManager.func_179126_j();
        } else if (ResearchManager.clientProgress.hasConstellationDiscovered(this.constellation.getTranslationKey())) {
            MoonPhase ph;
            int i;
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)0.7f, (float)0.6f);
            int size = 19;
            int offsetX = 95 + this.field_146294_l / 2 - this.phases.size() * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            for (i = 0; i < this.phases.size(); ++i) {
                ph = this.phases.get(i);
                if (this.activePhases.contains((Object)ph)) continue;
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            Blending.PREALPHA.applyStateManager();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < this.phases.size(); ++i) {
                ph = this.phases.get(i);
                if (!this.activePhases.contains((Object)ph)) continue;
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            Blending.DEFAULT.applyStateManager();
            TextureHelper.refreshTextureBindState();
        } else {
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            int size = 19;
            int offsetX = 95 + this.field_146294_l / 2 - this.phases.size() * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            for (int i = 0; i < this.phases.size(); ++i) {
                MoonPhase ph = this.phases.get(i);
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            TextureHelper.refreshTextureBindState();
        }
    }

    private void drawConstellation(final float partial) {
        float br = 0.866f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        String name = I18n.func_135052_a((String)this.constellation.getTranslationKey(), (Object[])new Object[0]).toUpperCase();
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(name);
        double offsetX = 305.0 - width * 1.8 / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 26), (double)0.0);
        GlStateManager.func_179139_a((double)1.8, (double)1.8, (double)1.8);
        fr.func_175065_a(name, 0.0f, 0.0f, -287449635, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        String dstInfo = "astralsorcery.journal.constellation.dst.";
        dstInfo = this.constellation instanceof IMajorConstellation ? dstInfo + "major" : (this.constellation instanceof IWeakConstellation ? dstInfo + "weak" : dstInfo + "minor");
        if (!this.detailed) {
            dstInfo = "???";
        }
        dstInfo = I18n.func_135052_a((String)dstInfo, (Object[])new Object[0]);
        width = fr.func_78256_a(dstInfo);
        offsetX = 305.0 - width / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 219), (double)0.0);
        fr.func_175065_a(dstInfo, 0.0f, 0.0f, -1713512995, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        final Random rand = new Random(4726142277924544921L);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.apply();
        boolean known = ResearchManager.clientProgress.hasConstellationDiscovered(this.constellation.getTranslationKey());
        RenderConstellation.renderConstellationIntoGUI(known ? this.constellation.getConstellationColor() : this.constellation.getTierRenderColor(), this.constellation, this.guiLeft + 40, this.guiTop + 60, this.field_73735_i, 150, 150, 2.0, new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return 0.3f + 0.7f * RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), partial, 12 + rand.nextInt(10));
            }
        }, true, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawArrows(float partialTicks, Point mouse) {
        int width = 30;
        int height = 15;
        this.rectBack = new Rectangle(this.guiLeft + 197, this.guiTop + 230, width, height);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.rectBack.getX() + (double)(width / 2)), (double)(this.rectBack.getY() + (double)(height / 2)), (double)0.0);
        float uFrom = 0.0f;
        float vFrom = 0.5f;
        if (this.rectBack.contains(mouse)) {
            uFrom = 0.5f;
            GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
        } else {
            double t = (float)ClientScheduler.getClientTick() + partialTicks;
            float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GlStateManager.func_179121_F();
    }

    @Override
    protected boolean handleRightClickClose(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
        return true;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.handleBookmarkClick(p)) {
            return;
        }
        if (this.rectBack != null && this.rectBack.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
            return;
        }
        if (this.rectPrev != null && this.rectPrev.contains(p)) {
            if (this.doublePageID >= 1) {
                --this.doublePageID;
            }
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        if (this.rectNext != null && this.rectNext.contains(p)) {
            if (this.doublePageID <= this.doublePages - 1) {
                ++this.doublePageID;
            }
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        if (this.doublePageID != 0 && this.lastFramePage != null) {
            this.lastFramePage.propagateMouseClick(mouseX, mouseY);
        }
    }
}

