/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class CraftTweakerHacks {
    private static final Field OREDICTIONARY_IDTOSTACK = CraftTweakerHacks.getField(OreDictionary.class, "idToStack");
    private static final Field OREDICTIONARY_IDTOSTACKUN = CraftTweakerHacks.getField(OreDictionary.class, "idToStackUn");
    private static final Field SEEDENTRY_SEED;
    private static final Constructor<? extends WeightedRandom.Item> SEEDENTRY_CONSTRUCTOR;

    private CraftTweakerHacks() {
    }

    public static List<WeightedRandom.Item> getSeeds() {
        return (List)CraftTweakerHacks.getPrivateStaticObject(ForgeHooks.class, "seedList");
    }

    public static List<NonNullList<ItemStack>> getOreIdStacks() {
        try {
            return (List)OREDICTIONARY_IDTOSTACK.get(null);
        }
        catch (IllegalAccessException ex) {
            CraftTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static List<NonNullList<ItemStack>> getOreIdStacksUn() {
        try {
            return (List)OREDICTIONARY_IDTOSTACKUN.get(null);
        }
        catch (IllegalAccessException ex) {
            CraftTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static ItemStack getSeedEntrySeed(Object entry) {
        try {
            return (ItemStack)SEEDENTRY_SEED.get(entry);
        }
        catch (IllegalAccessException ex) {
            CraftTweakerAPI.logError("could not get SeedEntry seed");
            return null;
        }
    }

    public static WeightedRandom.Item constructSeedEntry(WeightedItemStack stack) {
        try {
            return SEEDENTRY_CONSTRUCTOR.newInstance(CraftTweakerMC.getItemStack(stack.getStack()), (int)stack.getPercent());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            CraftTweakerAPI.logError("could not construct SeedEntry");
            return null;
        }
    }

    public static Map<String, String> getTranslations() {
        return (Map)CraftTweakerHacks.getPrivateObject(CraftTweakerHacks.getPrivateStaticObject(I18n.class, "localizedName", "field_74839_a"), "languageList", "field_74816_c");
    }

    public static <T> T getPrivateObject(Object object, String ... names) {
        Class<?> cls = object.getClass();
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(object);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    public static <T> T getPrivateStaticObject(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    private static Field getField(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    static {
        Class<?> forgeSeedEntry = null;
        try {
            forgeSeedEntry = Class.forName("net.minecraftforge.common.ForgeHooks$SeedEntry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SEEDENTRY_SEED = CraftTweakerHacks.getField(forgeSeedEntry, "seed");
        Constructor<?> seedEntryConstructor = null;
        try {
            seedEntryConstructor = forgeSeedEntry.getConstructor(ItemStack.class, Integer.TYPE);
            seedEntryConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            Logger.getLogger(CraftTweakerHacks.class.getName()).log(Level.SEVERE, null, ex);
        }
        SEEDENTRY_CONSTRUCTOR = seedEntryConstructor;
    }
}

