/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.minecraft;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.container.IContainer;
import crafttweaker.api.creativetabs.ICreativeTab;
import crafttweaker.api.damage.IDamageSource;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityAgeable;
import crafttweaker.api.entity.IEntityAnimal;
import crafttweaker.api.entity.IEntityArrow;
import crafttweaker.api.entity.IEntityArrowTipped;
import crafttweaker.api.entity.IEntityCreature;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.entity.IEntityFishHook;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.entity.IEntityLiving;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.entity.IEntityMob;
import crafttweaker.api.entity.IEntityThrowable;
import crafttweaker.api.entity.IEntityXp;
import crafttweaker.api.entity.attribute.IEntityAttribute;
import crafttweaker.api.entity.attribute.IEntityAttributeInstance;
import crafttweaker.api.entity.attribute.IEntityAttributeModifier;
import crafttweaker.api.game.ITeam;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IMutableItemStack;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientUnknown;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.api.potions.IPotionType;
import crafttweaker.api.server.IServer;
import crafttweaker.api.text.IStyle;
import crafttweaker.api.text.ITextComponent;
import crafttweaker.api.util.IAxisAlignedBB;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBiomeType;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IExplosion;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IRayTraceResult;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.block.MCBlockDefinition;
import crafttweaker.mc1120.block.MCBlockState;
import crafttweaker.mc1120.block.MCMaterial;
import crafttweaker.mc1120.block.MCRayTraceResult;
import crafttweaker.mc1120.block.MCSpecificBlock;
import crafttweaker.mc1120.block.MCWorldBlock;
import crafttweaker.mc1120.command.MCCommand;
import crafttweaker.mc1120.command.MCCommandSender;
import crafttweaker.mc1120.container.MCContainer;
import crafttweaker.mc1120.creativetabs.MCCreativeTab;
import crafttweaker.mc1120.damage.MCDamageSource;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.dispenser.MCBlockSource;
import crafttweaker.mc1120.entity.MCEntity;
import crafttweaker.mc1120.entity.MCEntityAgeable;
import crafttweaker.mc1120.entity.MCEntityAnimal;
import crafttweaker.mc1120.entity.MCEntityArrow;
import crafttweaker.mc1120.entity.MCEntityArrowTipped;
import crafttweaker.mc1120.entity.MCEntityCreature;
import crafttweaker.mc1120.entity.MCEntityEquipmentSlot;
import crafttweaker.mc1120.entity.MCEntityFishHook;
import crafttweaker.mc1120.entity.MCEntityItem;
import crafttweaker.mc1120.entity.MCEntityLiving;
import crafttweaker.mc1120.entity.MCEntityLivingBase;
import crafttweaker.mc1120.entity.MCEntityMob;
import crafttweaker.mc1120.entity.MCEntityThrowable;
import crafttweaker.mc1120.entity.MCEntityXp;
import crafttweaker.mc1120.entity.attribute.MCEntityAttribute;
import crafttweaker.mc1120.entity.attribute.MCEntityAttributeInstance;
import crafttweaker.mc1120.entity.attribute.MCEntityAttributeModifier;
import crafttweaker.mc1120.entity.expand.ExpandEntityEquipmentSlot;
import crafttweaker.mc1120.game.MCTeam;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.item.MCMutableItemStack;
import crafttweaker.mc1120.item.VanillaIngredient;
import crafttweaker.mc1120.liquid.MCLiquidDefinition;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import crafttweaker.mc1120.oredict.MCOreDictEntry;
import crafttweaker.mc1120.player.MCPlayer;
import crafttweaker.mc1120.potions.MCPotion;
import crafttweaker.mc1120.potions.MCPotionEffect;
import crafttweaker.mc1120.potions.MCPotionType;
import crafttweaker.mc1120.text.MCStyle;
import crafttweaker.mc1120.text.MCTextComponent;
import crafttweaker.mc1120.util.MCAxisAlignedBB;
import crafttweaker.mc1120.world.MCBiome;
import crafttweaker.mc1120.world.MCBlockPos;
import crafttweaker.mc1120.world.MCExplosion;
import crafttweaker.mc1120.world.MCFacing;
import crafttweaker.mc1120.world.MCVector3d;
import crafttweaker.mc1120.world.MCWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class CraftTweakerMC {
    public static final IBiome[] biomes;
    public static final Map<String, ICreativeTab> creativeTabs;
    private static final Map<Block, MCBlockDefinition> blockDefinitions;
    private static final HashMap<List, IOreDictEntry> oreDictArrays;

    private CraftTweakerMC() {
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError("Not a valid item stack: " + item);
            throw new IllegalArgumentException("Not a valid item stack: " + item);
        }
        return ((ItemStack)internal).func_77946_l();
    }

    public static ItemStack getItemStack(IMutableItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError("Not a valid item stack: " + item);
            throw new IllegalArgumentException("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    public static ItemStack getItemStack(IIngredient ingredient) {
        if (ingredient == null) {
            return ItemStack.field_190927_a;
        }
        List<IItemStack> items = ingredient.getItems();
        if (items.size() != 1) {
            CraftTweakerAPI.logError("Not an ingredient with a single item: " + ingredient);
        }
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return CraftTweakerMC.getItemStack(items.get(0));
    }

    public static IItemStack getIItemStack(ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return null;
        }
        return new MCItemStack(item);
    }

    public static IItemStack getIItemStackWildcardSize(ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return null;
        }
        return new MCItemStack(item, true);
    }

    public static IItemStack getIItemStackMutable(ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return null;
        }
        return new MCMutableItemStack(item);
    }

    public static IItemStack getIItemStackMutableWildcardSize(ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return null;
        }
        return new MCMutableItemStack(item, true);
    }

    public static IItemStack getIItemStackForMatching(ItemStack item) {
        return CraftTweakerMC.getIItemStackForMatching(item, false);
    }

    public static IItemStack getIItemStackForMatching(ItemStack item, boolean wildcardSize) {
        return wildcardSize ? CraftTweakerMC.getIItemStackMutableWildcardSize(item) : CraftTweakerMC.getIItemStackMutable(item);
    }

    public static IItemStack getIItemStackWildcardSize(Item item, int meta) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, meta), true);
    }

    public static IItemStack getIItemStackWildcard(Item item, int amount) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static ItemStack[] getExamples(IIngredient ingredient) {
        List<IItemStack> examples = ingredient.getItems();
        ItemStack[] result = new ItemStack[examples.size()];
        for (int i = 0; i < examples.size(); ++i) {
            result[i] = CraftTweakerMC.getItemStack(examples.get(i));
        }
        return result;
    }

    public static IItemStack getItemStack(Item item, int amount, int damage) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, amount, damage));
    }

    public static ItemStack[] getItemStacks(IItemStack ... items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                output[i] = ItemStack.field_190927_a;
                continue;
            }
            Object internal = items[i].getInternal();
            if (!(internal instanceof ItemStack) || ((ItemStack)internal).func_190926_b()) continue;
            output[i] = (ItemStack)internal;
        }
        return output;
    }

    public static ItemStack[] getItemStacks(List<IItemStack> items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i) == null) {
                output[i] = ItemStack.field_190927_a;
                continue;
            }
            Object internal = items.get(i).getInternal();
            if (internal instanceof ItemStack && !((ItemStack)internal).func_190926_b()) {
                output[i] = (ItemStack)internal;
                continue;
            }
            CraftTweakerAPI.logError("Invalid item stack: " + items.get(i));
        }
        return output;
    }

    public static IItemStack[] getIItemStacks(ItemStack ... items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            ItemStack itemStack = items[i];
            if (itemStack == null || itemStack.func_190926_b()) continue;
            result[i] = new MCItemStack(items[i]);
        }
        return result;
    }

    public static IItemStack[] getIItemStacks(List<ItemStack> items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.size()];
        for (int i = 0; i < result.length; ++i) {
            ItemStack itemStack = items.get(i);
            if (itemStack == null || itemStack.func_190926_b()) continue;
            result[i] = new MCItemStack(itemStack);
        }
        return result;
    }

    public static IOreDictEntry getOreDict(String name) {
        return new MCOreDictEntry(name);
    }

    public static IPlayer getIPlayer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return new MCPlayer(player);
    }

    public static EntityPlayer getPlayer(IPlayer player) {
        if (player == null) {
            return null;
        }
        if (!(player instanceof MCPlayer)) {
            CraftTweakerAPI.logError("Invalid player: " + player);
            return null;
        }
        return ((MCPlayer)player).getInternal();
    }

    public static IData getIData(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, true);
    }

    public static IData getIDataModifyable(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, false);
    }

    public static NBTBase getNBT(IData data) {
        if (data == null) {
            return null;
        }
        return NBTConverter.from(data);
    }

    public static NBTTagCompound getNBTCompound(IData data) {
        if (data == null) {
            return null;
        }
        return (NBTTagCompound)NBTConverter.from(data);
    }

    public static IBlock getBlock(IBlockAccess blocks, int x, int y, int z) {
        return new MCWorldBlock(blocks, x, y, z);
    }

    public static IBlockDefinition getBlockDefinition(Block block) {
        if (!blockDefinitions.containsKey(block)) {
            blockDefinitions.put(block, new MCBlockDefinition(block));
        }
        return blockDefinitions.get(block);
    }

    public static IBlock getBlockAnyMeta(Block block) {
        if (block == null) {
            return null;
        }
        return new MCSpecificBlock(block, Short.MAX_VALUE);
    }

    public static IBlock getBlock(Block block, int meta) {
        if (block == null) {
            return null;
        }
        return new MCSpecificBlock(block, meta);
    }

    public static Block getBlock(IItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return ((MCBlockDefinition)itemStack.asBlock().getDefinition()).getInternalBlock();
    }

    public static Block getBlock(IBlock block) {
        if (block == null) {
            return null;
        }
        return ((MCBlockDefinition)block.getDefinition()).getInternalBlock();
    }

    public static Block getBlock(IBlockDefinition blockDefinition) {
        if (blockDefinition instanceof MCBlockDefinition) {
            return ((MCBlockDefinition)blockDefinition).getInternalBlock();
        }
        Object block = blockDefinition.getInternal();
        return block instanceof Block ? (Block)block : null;
    }

    public static FluidStack getLiquidStack(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return (FluidStack)stack.getInternal();
    }

    public static FluidStack[] getLiquidStacks(ILiquidStack[] stacks) {
        if (stacks == null) {
            return null;
        }
        FluidStack[] res = new FluidStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            ILiquidStack liquidStack = stacks[i];
            res[i] = CraftTweakerMC.getLiquidStack(liquidStack);
        }
        return res;
    }

    public static ILiquidStack getILiquidStack(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static IOreDictEntry getOreDictEntryFromArray(List array) {
        if (!oreDictArrays.containsKey(array)) {
            for (String ore : OreDictionary.getOreNames()) {
                if (OreDictionary.getOres((String)ore) != array) continue;
                oreDictArrays.put(array, CraftTweakerAPI.oreDict.get(ore));
            }
        }
        return oreDictArrays.get(array);
    }

    public static IIngredient getIIngredient(Object ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof String) {
            return CraftTweakerAPI.oreDict.get((String)ingredient);
        }
        if (ingredient instanceof Item) {
            return CraftTweakerMC.getIItemStack(new ItemStack((Item)ingredient, 1, 0));
        }
        if (ingredient instanceof ItemStack) {
            return CraftTweakerMC.getIItemStack((ItemStack)ingredient);
        }
        if (ingredient instanceof List) {
            IOreDictEntry entry = CraftTweakerMC.getOreDictEntryFromArray((List)ingredient);
            if (entry == null) {
                return IngredientUnknown.INSTANCE;
            }
            return entry;
        }
        if (ingredient instanceof FluidStack) {
            return new MCLiquidStack((FluidStack)ingredient);
        }
        if (ingredient instanceof Ingredient) {
            if (ingredient instanceof OreIngredient) {
                return CraftTweakerMC.getOreDict((OreIngredient)ingredient);
            }
            if (ingredient instanceof CompoundIngredient) {
                return CraftTweakerMC.mergeIngredients((IIngredient[])((CompoundIngredient)ingredient).getChildren().stream().map(CraftTweakerMC::getIIngredient).toArray(IIngredient[]::new));
            }
            ItemStack[] matchingStacks = ((Ingredient)ingredient).field_193371_b;
            if (ingredient == Ingredient.field_193370_a || matchingStacks.length <= 0 || ((Ingredient)ingredient).apply(ItemStack.field_190927_a)) {
                return null;
            }
            return CraftTweakerMC.mergeIngredients(CraftTweakerMC.getIItemStacks(matchingStacks));
        }
        throw new IllegalArgumentException("Not a valid ingredient: " + ingredient);
    }

    public static IIngredient mergeIngredients(IIngredient ... ingredients) {
        if (ingredients == null || ingredients.length == 0) {
            return null;
        }
        IIngredient[] objects = (IIngredient[])Arrays.stream(ingredients).filter(i -> i != IngredientUnknown.INSTANCE).toArray(IIngredient[]::new);
        if (objects.length == 0) {
            return null;
        }
        if (objects.length == 1) {
            return objects[0];
        }
        return new IngredientOr(objects);
    }

    public static Ingredient getIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return Ingredient.field_193370_a;
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName());
        }
        if (ingredient instanceof IItemStack) {
            if (((IItemStack)ingredient).hasTag() && ((IItemStack)ingredient).getMatchTagExact()) {
                return new IngredientNBT(CraftTweakerMC.getItemStack(ingredient)){};
            }
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CraftTweakerMC.getItemStack((IItemStack)ingredient)});
        }
        return new VanillaIngredient(ingredient);
    }

    private static IOreDictEntry getOreDict(OreIngredient oreIngredient) {
        return MCOreDictEntry.getFromIngredient(oreIngredient);
    }

    public static IWorld getWorldByID(int id) {
        return new MCWorld((World)DimensionManager.getWorld((int)id));
    }

    public static IWorld getIWorld(World world) {
        return world == null ? null : new MCWorld(world);
    }

    public static World getWorld(IWorld world) {
        return world == null ? null : (World)world.getInternal();
    }

    public static boolean matches(IItemStack iitem, ItemStack stack, boolean wildcardsize) {
        ItemStack internal = ItemStack.field_190927_a;
        if (iitem != null) {
            internal = (ItemStack)iitem.getInternal();
            if (stack.func_77942_o()) {
                return CraftTweakerMC.matchesExact(iitem, stack);
            }
        }
        return !internal.func_190926_b() && !stack.func_190926_b() && internal.func_77973_b() == stack.func_77973_b() && (wildcardsize || internal.func_190916_E() >= stack.func_190916_E()) && (stack.func_77952_i() == Short.MAX_VALUE || stack.func_77952_i() == internal.func_77952_i() || !stack.func_77981_g() && !stack.func_77973_b().func_77645_m());
    }

    public static boolean matches(IItemStack iitem, ItemStack stack) {
        return CraftTweakerMC.matches(iitem, stack, true);
    }

    public static boolean matchesExact(IItemStack item, ItemStack stack) {
        ItemStack internal = CraftTweakerMC.getItemStack(item);
        if (internal.func_77978_p() != null && stack.func_77978_p() == null) {
            return false;
        }
        if (internal.func_77978_p() == null && stack.func_77978_p() != null) {
            return false;
        }
        if (internal.func_77978_p() == null) {
            return stack.func_77973_b() == internal.func_77973_b() && (internal.func_77960_j() == Short.MAX_VALUE || stack.func_77960_j() == internal.func_77960_j());
        }
        if (internal.func_77978_p().func_150296_c().equals(stack.func_77978_p().func_150296_c())) {
            for (String s : internal.func_77978_p().func_150296_c()) {
                if (internal.func_77978_p().func_74781_a(s).equals((Object)stack.func_77978_p().func_74781_a(s))) continue;
                return false;
            }
        }
        return stack.func_77973_b() == internal.func_77973_b() && (internal.func_77960_j() == Short.MAX_VALUE || stack.func_77960_j() == internal.func_77960_j());
    }

    public static crafttweaker.api.block.IBlockState getBlockState(IBlockState block) {
        return block == null ? null : new MCBlockState(block);
    }

    public static IBlockState getBlockState(crafttweaker.api.block.IBlockState block) {
        return block == null ? null : (IBlockState)block.getInternal();
    }

    public static IEntity getIEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityLivingBase) {
            return CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)entity);
        }
        if (entity instanceof EntityItem) {
            return new MCEntityItem((EntityItem)entity);
        }
        if (entity instanceof EntityXPOrb) {
            return new MCEntityXp((EntityXPOrb)entity);
        }
        if (entity instanceof EntityFishHook) {
            return new MCEntityFishHook((EntityFishHook)entity);
        }
        if (entity instanceof EntityArrow) {
            return CraftTweakerMC.getIEntityArrow((EntityArrow)entity);
        }
        if (entity instanceof EntityThrowable) {
            return new MCEntityThrowable((EntityThrowable)entity);
        }
        return new MCEntity(entity);
    }

    public static IEntityXp getIEntityXp(EntityXPOrb entityXPOrb) {
        return entityXPOrb == null ? null : new MCEntityXp(entityXPOrb);
    }

    public static IEntityItem getIEntityItem(EntityItem entityItem) {
        return entityItem == null ? null : new MCEntityItem(entityItem);
    }

    public static Entity getEntity(IEntity entity) {
        return entity == null ? null : (Entity)entity.getInternal();
    }

    public static IEntityLivingBase getIEntityLivingBase(EntityLivingBase entityLivingBase) {
        if (entityLivingBase == null) {
            return null;
        }
        if (entityLivingBase instanceof EntityPlayer) {
            return CraftTweakerMC.getIPlayer((EntityPlayer)entityLivingBase);
        }
        if (entityLivingBase instanceof EntityLiving) {
            return CraftTweakerMC.getIEntityLiving((EntityLiving)entityLivingBase);
        }
        return new MCEntityLivingBase(entityLivingBase);
    }

    public static IEntityLiving getIEntityLiving(EntityLiving entityLiving) {
        if (entityLiving == null) {
            return null;
        }
        if (entityLiving instanceof EntityCreature) {
            return CraftTweakerMC.getIEntityCreature((EntityCreature)entityLiving);
        }
        return new MCEntityLiving(entityLiving);
    }

    public static IEntityCreature getIEntityCreature(EntityCreature entityCreature) {
        if (entityCreature == null) {
            return null;
        }
        if (entityCreature instanceof EntityAgeable) {
            return CraftTweakerMC.getIEntityAgeable((EntityAgeable)entityCreature);
        }
        if (entityCreature instanceof EntityMob) {
            return CraftTweakerMC.getIEntityMob((EntityMob)entityCreature);
        }
        return new MCEntityCreature(entityCreature);
    }

    public static IEntityAgeable getIEntityAgeable(EntityAgeable entityAgeable) {
        if (entityAgeable == null) {
            return null;
        }
        if (entityAgeable instanceof EntityAnimal) {
            return CraftTweakerMC.getIEntityAnimal((EntityAnimal)entityAgeable);
        }
        return new MCEntityAgeable(entityAgeable);
    }

    public static IEntityAnimal getIEntityAnimal(EntityAnimal entityAnimal) {
        return entityAnimal == null ? null : new MCEntityAnimal(entityAnimal);
    }

    public static IEntityMob getIEntityMob(EntityMob entityMob) {
        return entityMob == null ? null : new MCEntityMob(entityMob);
    }

    public static IBlockPos getIBlockPos(BlockPos pos) {
        return pos == null ? null : new MCBlockPos(pos);
    }

    public static BlockPos getBlockPos(IBlockPos pos) {
        return pos == null ? null : (BlockPos)pos.getInternal();
    }

    public static ITeam getITeam(Team team) {
        return team == null ? null : new MCTeam(team);
    }

    public static Team getTeam(ITeam team) {
        return team == null ? null : (Team)team.getInternal();
    }

    public static IDamageSource getIDamageSource(DamageSource source) {
        return source == null ? null : new MCDamageSource(source);
    }

    public static DamageSource getDamageSource(IDamageSource source) {
        return source == null ? null : (DamageSource)source.getInternal();
    }

    public static IMaterial getIMaterial(Material material) {
        return material == null ? null : new MCMaterial(material);
    }

    public static Material getMaterial(IMaterial material) {
        return material == null ? null : (Material)material.getInternal();
    }

    public static EntityAnimal getEntityAnimal(IEntityAnimal entityAnimal) {
        return entityAnimal == null ? null : (EntityAnimal)entityAnimal.getInternal();
    }

    public static IEntityEquipmentSlot getIEntityEquipmentSlot(EntityEquipmentSlot slot) {
        return slot == null ? null : new MCEntityEquipmentSlot(slot);
    }

    public static EntityEquipmentSlot getEntityEquipmentSlot(IEntityEquipmentSlot slot) {
        return slot == null ? null : (EntityEquipmentSlot)slot.getInternal();
    }

    public static EntityLivingBase getEntityLivingBase(IEntityLivingBase entityLivingBase) {
        return entityLivingBase == null ? null : (EntityLivingBase)entityLivingBase.getInternal();
    }

    public static IPotion getIPotion(Potion potion) {
        return potion == null ? null : new MCPotion(potion);
    }

    public static Potion getPotion(IPotion potion) {
        return potion == null ? null : (Potion)potion.getInternal();
    }

    public static IPotionEffect getIPotionEffect(PotionEffect potionEffect) {
        return potionEffect == null ? null : new MCPotionEffect(potionEffect);
    }

    public static PotionEffect getPotionEffect(IPotionEffect potionEffect) {
        return potionEffect == null ? null : (PotionEffect)potionEffect.getInternal();
    }

    public static IIngredient[] getIIngredients(List<Ingredient> ingredientList) {
        if (ingredientList == null) {
            return new IIngredient[0];
        }
        IIngredient[] out = new IIngredient[ingredientList.size()];
        for (int index = 0; index < out.length; ++index) {
            out[index] = CraftTweakerMC.getIIngredient(ingredientList.get(index));
        }
        return out;
    }

    public static EntityItem getEntityItem(IEntityItem entityItem) {
        return entityItem == null ? null : (EntityItem)entityItem.getInternal();
    }

    public static IRayTraceResult getIRayTraceResult(RayTraceResult rayTraceResult) {
        return rayTraceResult == null ? null : new MCRayTraceResult(rayTraceResult);
    }

    public static RayTraceResult getRayTraceResult(IRayTraceResult rayTraceResult) {
        return rayTraceResult == null ? null : (RayTraceResult)rayTraceResult.getInternal();
    }

    public static IContainer getIContainer(Container container) {
        return container == null ? null : new MCContainer(container);
    }

    public static Container getContainer(IContainer container) {
        return container == null ? null : (Container)container.getInternal();
    }

    public static IFacing getIFacing(EnumFacing sideHit) {
        return sideHit == null ? null : new MCFacing(sideHit);
    }

    public static CreativeTabs getCreativeTabs(ICreativeTab tab) {
        return tab == null ? null : (CreativeTabs)tab.getInternal();
    }

    public static ICommandSender getICommandSender(crafttweaker.api.command.ICommandSender sender) {
        return sender == null ? null : (ICommandSender)sender.getInternal();
    }

    public static crafttweaker.api.command.ICommandSender getICommandSender(ICommandSender sender) {
        if (sender instanceof Entity) {
            return CraftTweakerMC.getIEntity((Entity)sender);
        }
        return sender == null ? null : new MCCommandSender(sender);
    }

    public static crafttweaker.api.command.ICommand getICommand(ICommand iCommand) {
        return iCommand == null ? null : new MCCommand(iCommand);
    }

    public static ICommand getICommand(crafttweaker.api.command.ICommand command) {
        return command == null ? null : (ICommand)command.getInternal();
    }

    public static MinecraftServer getMCServer(IServer server) {
        return server == null ? null : (MinecraftServer)server.getInternal();
    }

    public static Vec3d getVec3d(IVector3d vector3d) {
        return vector3d == null ? null : (Vec3d)vector3d.getInternal();
    }

    public static IVector3d getIVector3d(Vec3d vec3d) {
        return vec3d == null ? null : new MCVector3d(vec3d);
    }

    public static List<IItemStack> getIItemStackList(List<ItemStack> items) {
        ArrayList<IItemStack> out = new ArrayList<IItemStack>();
        if (items == null || items.isEmpty()) {
            return out;
        }
        for (ItemStack itemStack : items) {
            IItemStack stack = CraftTweakerMC.getIItemStack(itemStack);
            if (stack == null) continue;
            out.add(stack);
        }
        return out;
    }

    public static List<IItemStack> getIItemStacks(Collection<ItemStack> items) {
        ArrayList<IItemStack> convertedOutputs = new ArrayList<IItemStack>();
        if (items != null && !items.isEmpty()) {
            for (ItemStack itemStack : items) {
                IItemStack stack = CraftTweakerMC.getIItemStack(itemStack);
                if (stack == null || stack.isEmpty()) continue;
                convertedOutputs.add(stack);
            }
        }
        return convertedOutputs;
    }

    public static List<WeightedItemStack> getWeightedItemStackList(List<ItemStack> items) {
        ArrayList<WeightedItemStack> out = new ArrayList<WeightedItemStack>();
        if (items == null || items.isEmpty()) {
            return out;
        }
        for (ItemStack itemStack : items) {
            IItemStack stack = CraftTweakerMC.getIItemStack(itemStack);
            if (stack == null) continue;
            out.add(new WeightedItemStack(stack, 100.0f));
        }
        return out;
    }

    public static Fluid getFluid(ILiquidDefinition liquidDefinition) {
        return liquidDefinition == null ? null : (Fluid)liquidDefinition.getInternal();
    }

    public static ILiquidDefinition getILiquidDefinition(Fluid fluid) {
        return fluid == null ? null : new MCLiquidDefinition(fluid);
    }

    public static Biome getBiome(IBiome biome) {
        return biome == null ? null : (biome instanceof MCBiome ? ((MCBiome)biome).getInternal() : (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biome.getId())));
    }

    public static IExplosion getIExplosion(Explosion explosion) {
        return explosion == null ? null : new MCExplosion(explosion);
    }

    public static Explosion getExplosion(IExplosion explosion) {
        return explosion instanceof MCExplosion ? (Explosion)explosion.getInternal() : null;
    }

    public static IEntityFishHook getIEntityFishHook(EntityFishHook entity) {
        return entity == null ? null : new MCEntityFishHook(entity);
    }

    public static IEntityAttributeInstance getAttributeInstance(IAttributeInstance instance) {
        return instance == null ? null : new MCEntityAttributeInstance(instance);
    }

    public static IAttributeInstance getAttributeInstance(IEntityAttributeInstance instance) {
        return instance == null ? null : (IAttributeInstance)instance.getInternal();
    }

    public static AttributeModifier getAttributeModifier(IEntityAttributeModifier modifier) {
        return modifier == null ? null : (AttributeModifier)modifier.getInternal();
    }

    public static IEntityAttributeModifier getIEntityAttributeModifier(AttributeModifier modifier) {
        return modifier == null ? null : new MCEntityAttributeModifier(modifier);
    }

    public static IEntityArrow getIEntityArrow(EntityArrow entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityTippedArrow) {
            return new MCEntityArrowTipped((EntityTippedArrow)entity);
        }
        return new MCEntityArrow(entity);
    }

    public static IEntityArrowTipped getIEntityArrowTipped(EntityTippedArrow entity) {
        return entity == null ? null : new MCEntityArrowTipped(entity);
    }

    public static IEntityThrowable getIEntityThrowable(EntityThrowable entity) {
        return entity == null ? null : new MCEntityThrowable(entity);
    }

    public static IPotionEffect[] getIPotionEffects(List<PotionEffect> potionEffects) {
        if (potionEffects == null) {
            return null;
        }
        IPotionEffect[] result = new IPotionEffect[potionEffects.size()];
        for (int i = 0; i < result.length; ++i) {
            PotionEffect potionEffect = potionEffects.get(i);
            if (potionEffect == null) continue;
            result[i] = new MCPotionEffect(potionEffect);
        }
        return result;
    }

    public static PotionType getPotionType(IPotionType potionType) {
        return potionType == null ? null : (PotionType)potionType.getInternal();
    }

    public static IPotionType getIPotionType(PotionType potionType) {
        return potionType == null ? null : new MCPotionType(potionType);
    }

    public static AxisAlignedBB getAxisAlignedBB(IAxisAlignedBB aabb) {
        return aabb == null ? null : (AxisAlignedBB)aabb.getInternal();
    }

    public static IAxisAlignedBB getIAxisAlignedBB(AxisAlignedBB aabb) {
        return aabb == null ? null : new MCAxisAlignedBB(aabb);
    }

    public static IEntityAttribute getIEntityAttribute(IAttribute attribute) {
        return attribute == null ? null : new MCEntityAttribute(attribute);
    }

    public static IEntityAttributeInstance getIEntityAttributeInstance(IAttributeInstance attribute) {
        return attribute == null ? null : new MCEntityAttributeInstance(attribute);
    }

    public static EnumHand getHand(IEntityEquipmentSlot hand) {
        if (hand == null) {
            return null;
        }
        switch (CraftTweakerMC.getEntityEquipmentSlot(hand)) {
            case MAINHAND: {
                return EnumHand.MAIN_HAND;
            }
            case OFFHAND: {
                return EnumHand.OFF_HAND;
            }
        }
        return null;
    }

    public static IEntityEquipmentSlot getIEntityEquipmentSlot(EnumHand hand) {
        if (hand == null) {
            return null;
        }
        switch (hand) {
            case MAIN_HAND: {
                return ExpandEntityEquipmentSlot.mainHand();
            }
            case OFF_HAND: {
                return ExpandEntityEquipmentSlot.offhand();
            }
        }
        return null;
    }

    public static EnumFacing getFacing(IFacing facing) {
        return facing == null ? null : (EnumFacing)facing.getInternal();
    }

    public static Item getItem(IItemDefinition itemDefinition) {
        return itemDefinition == null ? null : (Item)itemDefinition.getInternal();
    }

    public static BiomeDictionary.Type getBiomeType(IBiomeType biomeType) {
        return biomeType == null ? null : (BiomeDictionary.Type)biomeType.getInternal();
    }

    public static IStyle getIStyle(Style style) {
        return style == null ? null : new MCStyle(style);
    }

    public static Style getStyle(IStyle style) {
        return style == null ? null : (Style)style.getInternal();
    }

    public static ITextComponent getITextComponent(net.minecraft.util.text.ITextComponent textComponent) {
        return textComponent == null ? null : new MCTextComponent(textComponent);
    }

    public static net.minecraft.util.text.ITextComponent getITextComponent(ITextComponent textComponent) {
        return textComponent == null ? null : (net.minecraft.util.text.ITextComponent)textComponent.getInternal();
    }

    public static crafttweaker.api.dispenser.IBlockSource getBlockSource(IBlockSource blockSource) {
        return blockSource == null ? null : new MCBlockSource(blockSource);
    }

    public static IBlockSource getBlockSource(crafttweaker.api.dispenser.IBlockSource blockSource) {
        return blockSource == null ? null : (IBlockSource)blockSource.getInternal();
    }

    static {
        creativeTabs = new HashMap<String, ICreativeTab>();
        blockDefinitions = new HashMap<Block, MCBlockDefinition>();
        oreDictArrays = new HashMap();
        biomes = new IBiome[Biome.field_185377_q.func_148742_b().size()];
        for (int i = 0; i < Biome.field_185377_q.func_148742_b().size(); ++i) {
            if (Biome.field_185377_q.func_148754_a(i) == null) continue;
            CraftTweakerMC.biomes[i] = new MCBiome((Biome)Biome.field_185377_q.func_148754_a(i));
        }
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (tab == null) continue;
            String label = tab.field_78034_o;
            creativeTabs.put(label, new MCCreativeTab(tab, label));
        }
    }
}

