/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import appeng.tile.networking.TileCableBus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"facingPos", "Lnet/minecraft/util/math/BlockPos;", "Lappeng/parts/AEBasePart;", "getFacingPos", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/util/math/BlockPos;", "facingTile", "Lnet/minecraft/tileentity/TileEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/tileentity/TileEntity;", "getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/IBlockAccess;", "pos", "getPart", "Lappeng/api/parts/IPart;", "hitX", "", "hitY", "hitZ", "betterp2p"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull IBlockAccess w, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntity te = w.func_175625_s(pos);
        ICableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = (ICableBusContainer)((TileCableBus)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull IBlockAccess w, @NotNull BlockPos pos, float hitX, float hitY, float hitZ) {
        SelectedPart p;
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        TileEntity te = w.func_175625_s(pos);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart selectedPart = p = ((IPartHost)te).selectPart(vec);
        return selectedPart != null ? selectedPart.part : null;
    }

    @Nullable
    public static final BlockPos getFacingPos(@NotNull AEBasePart $this$facingPos) {
        BlockPos blockPos;
        Intrinsics.checkParameterIsNotNull((Object)$this$facingPos, (String)"$this$facingPos");
        IPartHost iPartHost = $this$facingPos.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getPos()) != null) {
            AEPartLocation aEPartLocation = $this$facingPos.getSide();
            if (aEPartLocation == null || (aEPartLocation = aEPartLocation.getFacing()) == null) {
                aEPartLocation = EnumFacing.UP;
            }
            blockPos = iPartHost.func_177972_a((EnumFacing)aEPartLocation);
        } else {
            blockPos = null;
        }
        return blockPos;
    }

    @Nullable
    public static final TileEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        BlockPos pos;
        Intrinsics.checkParameterIsNotNull((Object)$this$facingTile, (String)"$this$facingTile");
        IPartHost iPartHost = $this$facingTile.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
        if (iPartHost.isInWorld() && (pos = CableBusUtilKt.getFacingPos($this$facingTile)) != null) {
            IPartHost iPartHost2 = $this$facingTile.getHost();
            return iPartHost2 != null && (iPartHost2 = iPartHost2.getLocation()) != null && (iPartHost2 = iPartHost2.getWorld()) != null ? iPartHost2.func_175625_s(pos) : null;
        }
        return null;
    }
}

