/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\n\u00a8\u0006\u000b"}, d2={"readP2PLocation", "Lcom/projecturanus/betterp2p/network/data/P2PLocation;", "buf", "Lio/netty/buffer/ByteBuf;", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "writeP2PLocation", "loc", "", "toLoc", "Lappeng/parts/p2p/PartP2PTunnel;", "betterp2p"})
public final class P2PLocationKt {
    public static final void writeP2PLocation(@NotNull ByteBuf buf, @NotNull P2PLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        buf.writeLong(loc.getPos().func_177986_g());
        buf.writeByte(loc.getFacing().ordinal());
        buf.writeInt(loc.getDim());
    }

    @Nullable
    public static final P2PLocation readP2PLocation(@NotNull ByteBuf buf) {
        P2PLocation p2PLocation;
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        try {
            BlockPos blockPos = BlockPos.func_177969_a((long)buf.readLong());
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.fromLong(buf.readLong())");
            p2PLocation = new P2PLocation(blockPos, EnumFacing.values()[buf.readByte()], buf.readInt());
        }
        catch (Exception e) {
            e.printStackTrace();
            p2PLocation = null;
        }
        return p2PLocation;
    }

    @NotNull
    public static final NBTTagCompound writeP2PLocation(@Nullable P2PLocation loc) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (loc != null) {
            nbt.func_74772_a("pos", loc.getPos().func_177986_g());
            nbt.func_74774_a("facing", (byte)loc.getFacing().ordinal());
            nbt.func_74768_a("dim", loc.getDim());
        }
        return nbt;
    }

    @Nullable
    public static final P2PLocation readP2PLocation(@NotNull NBTTagCompound tag) {
        P2PLocation p2PLocation;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        try {
            BlockPos blockPos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.fromLong(tag.getLong(\"pos\"))");
            p2PLocation = new P2PLocation(blockPos, EnumFacing.values()[tag.func_74771_c("facing")], tag.func_74762_e("dim"));
        }
        catch (Exception e) {
            e.printStackTrace();
            p2PLocation = null;
        }
        return p2PLocation;
    }

    @NotNull
    public static final P2PLocation toLoc(@NotNull PartP2PTunnel<?> $this$toLoc) {
        Intrinsics.checkParameterIsNotNull($this$toLoc, (String)"$this$toLoc");
        DimensionalCoord dimensionalCoord = $this$toLoc.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location");
        BlockPos blockPos = dimensionalCoord.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"location.pos");
        AEPartLocation aEPartLocation = $this$toLoc.getSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"side");
        EnumFacing enumFacing = aEPartLocation.getFacing();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"side.facing");
        DimensionalCoord dimensionalCoord2 = $this$toLoc.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord2, (String)"location");
        WorldProvider worldProvider = dimensionalCoord2.getWorld().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"location.world.provider");
        return new P2PLocation(blockPos, enumFacing, worldProvider.getDimension());
    }
}

