/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridNode;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"readP2PInfo", "Lcom/projecturanus/betterp2p/network/data/P2PInfo;", "buf", "Lio/netty/buffer/ByteBuf;", "writeP2PInfo", "", "info", "toInfo", "Lappeng/parts/p2p/PartP2PTunnel;", "betterp2p"})
public final class P2PInfoKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final P2PInfo readP2PInfo(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        try {
            short freq = buf.readShort();
            BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
            int world = buf.readInt();
            EnumFacing facing = EnumFacing.values()[buf.readInt()];
            int nameLength = buf.readShort() - 1;
            StringBuilder name = new StringBuilder();
            int n = 0;
            int n2 = nameLength;
            if (n <= n2) {
                while (true) {
                    void i;
                    name.append(buf.readChar());
                    if (i == n2) break;
                    ++i;
                }
            }
            boolean output = buf.readBoolean();
            boolean hasChannel = buf.readBoolean();
            byte channels2 = buf.readByte();
            byte type = buf.readByte();
            BlockPos blockPos = pos;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
            String string = name.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.toString()");
            return new P2PInfo(freq, blockPos, world, facing, string, output, hasChannel, channels2, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void writeP2PInfo(@NotNull ByteBuf buf, @NotNull P2PInfo info2) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
        buf.writeShort((int)info2.getFrequency());
        buf.writeLong(info2.getPos().func_177986_g());
        buf.writeInt(info2.getDim());
        buf.writeInt(info2.getFacing().func_176745_a());
        buf.writeShort(info2.getName().length());
        String string = info2.getName();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            buf.writeChar((int)c);
        }
        buf.writeBoolean(info2.getOutput());
        buf.writeBoolean(info2.getHasChannel());
        buf.writeByte(info2.getChannels());
        buf.writeByte(info2.getType());
    }

    @NotNull
    public static final P2PInfo toInfo(@NotNull PartP2PTunnel<?> $this$toInfo) {
        Intrinsics.checkParameterIsNotNull($this$toInfo, (String)"$this$toInfo");
        short s = $this$toInfo.getFrequency();
        DimensionalCoord dimensionalCoord = $this$toInfo.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location");
        BlockPos blockPos = dimensionalCoord.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"location.pos");
        DimensionalCoord dimensionalCoord2 = $this$toInfo.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord2, (String)"location");
        WorldProvider worldProvider = dimensionalCoord2.getWorld().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"location.world.provider");
        int n = worldProvider.getDimension();
        AEPartLocation aEPartLocation = $this$toInfo.getSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"side");
        EnumFacing enumFacing = aEPartLocation.getFacing();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"side.facing");
        String string = $this$toInfo.getCustomInventoryName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"customInventoryName");
        boolean bl = $this$toInfo.isOutput();
        boolean bl2 = P2PUtilKt.getHasChannel($this$toInfo);
        IGridNode iGridNode = $this$toInfo.getExternalFacingNode();
        if (!(iGridNode instanceof GridNode)) {
            iGridNode = null;
        }
        GridNode gridNode = (GridNode)iGridNode;
        return new P2PInfo(s, blockPos, n, enumFacing, string, bl, bl2, gridNode != null ? gridNode.usedChannels() : -1, P2PUtilKt.getTypeIndex($this$toInfo));
    }
}

