/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network;

import appeng.api.networking.IGrid;
import com.projecturanus.betterp2p.network.ModNetwork;
import com.projecturanus.betterp2p.network.PlayerRequest;
import com.projecturanus.betterp2p.network.data.GridServerCache;
import com.projecturanus.betterp2p.network.data.MemoryInfo;
import com.projecturanus.betterp2p.network.packet.C2SCloseGui;
import com.projecturanus.betterp2p.network.packet.C2SLinkP2P;
import com.projecturanus.betterp2p.network.packet.C2SRefreshP2PList;
import com.projecturanus.betterp2p.network.packet.C2SRenameP2P;
import com.projecturanus.betterp2p.network.packet.C2STypeChange;
import com.projecturanus.betterp2p.network.packet.C2SUnlinkP2P;
import com.projecturanus.betterp2p.network.packet.C2SUpdateMemoryInfo;
import com.projecturanus.betterp2p.network.packet.ClientOpenGuiHandler;
import com.projecturanus.betterp2p.network.packet.ClientUpdateP2PHandler;
import com.projecturanus.betterp2p.network.packet.S2COpenGui;
import com.projecturanus.betterp2p.network.packet.S2CUpdateP2P;
import com.projecturanus.betterp2p.network.packet.ServerCloseGuiHandler;
import com.projecturanus.betterp2p.network.packet.ServerLinkP2PHandler;
import com.projecturanus.betterp2p.network.packet.ServerRefreshP2PListHandler;
import com.projecturanus.betterp2p.network.packet.ServerRenameP2PTunnel;
import com.projecturanus.betterp2p.network.packet.ServerTypeChangeHandler;
import com.projecturanus.betterp2p.network.packet.ServerUnlinkP2PHandler;
import com.projecturanus.betterp2p.network.packet.ServerUpdateInfoHandler;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/projecturanus/betterp2p/network/ModNetwork;", "", "()V", "channel", "Lnet/minecraftforge/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "getChannel", "()Lnet/minecraftforge/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "networkWorker", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "playerState", "", "Ljava/util/UUID;", "Lcom/projecturanus/betterp2p/network/PlayerRequest;", "getPlayerState", "()Ljava/util/Map;", "initConnection", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "grid", "Lappeng/api/networking/IGrid;", "info", "Lcom/projecturanus/betterp2p/network/data/MemoryInfo;", "registerNetwork", "removeConnection", "requestP2PList", "type", "", "requestP2PUpdate", "stop", "betterp2p"})
public final class ModNetwork {
    @NotNull
    private static final SimpleNetworkWrapper channel;
    @NotNull
    private static final Map<UUID, PlayerRequest> playerState;
    private static ScheduledThreadPoolExecutor networkWorker;
    public static final ModNetwork INSTANCE;

    @NotNull
    public final SimpleNetworkWrapper getChannel() {
        return channel;
    }

    @NotNull
    public final Map<UUID, PlayerRequest> getPlayerState() {
        return playerState;
    }

    public final void registerNetwork() {
        int id = 0;
        channel.registerMessage(ClientOpenGuiHandler.class, S2COpenGui.class, id++, Side.CLIENT);
        channel.registerMessage(ClientUpdateP2PHandler.class, S2CUpdateP2P.class, id++, Side.CLIENT);
        channel.registerMessage(ServerLinkP2PHandler.class, C2SLinkP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerCloseGuiHandler.class, C2SCloseGui.class, id++, Side.SERVER);
        channel.registerMessage(ServerUpdateInfoHandler.class, C2SUpdateMemoryInfo.class, id++, Side.SERVER);
        channel.registerMessage(ServerRenameP2PTunnel.class, C2SRenameP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerRefreshP2PListHandler.class, C2SRefreshP2PList.class, id++, Side.SERVER);
        channel.registerMessage(ServerUnlinkP2PHandler.class, C2SUnlinkP2P.class, id++, Side.SERVER);
        channel.registerMessage(ServerTypeChangeHandler.class, C2STypeChange.class, id++, Side.SERVER);
        networkWorker = new ScheduledThreadPoolExecutor(1, registerNetwork.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PList(@NotNull EntityPlayer player, int type) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            boolean bl3 = false;
            PlayerRequest playerRequest = playerState.get(player.func_110124_au());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            cache.setType(type);
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendTo((IMessage)new S2CUpdateP2P(cache.retrieveP2PList(), true), (EntityPlayerMP)player);
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                }
                scheduledThreadPoolExecutor.schedule(new Runnable(cache, playerState, player, type){
                    final /* synthetic */ GridServerCache $cache;
                    final /* synthetic */ PlayerRequest $playerState;
                    final /* synthetic */ EntityPlayer $player$inlined;
                    final /* synthetic */ int $type$inlined;
                    {
                        this.$cache = gridServerCache;
                        this.$playerState = playerRequest;
                        this.$player$inlined = entityPlayer;
                        this.$type$inlined = n;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        Map<UUID, PlayerRequest> map = ModNetwork.INSTANCE.getPlayerState();
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (map) {
                            boolean bl3 = false;
                            EntityPlayer entityPlayer = this.$player$inlined;
                            if (entityPlayer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                            }
                            ModNetwork.INSTANCE.getChannel().sendTo((IMessage)new S2CUpdateP2P(this.$cache.retrieveP2PList(), true), (EntityPlayerMP)entityPlayer);
                            this.$playerState.setUpdatePending$betterp2p(false);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }, playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PUpdate(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            boolean bl3 = false;
            PlayerRequest playerRequest = playerState.get(player.func_110124_au());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendTo((IMessage)new S2CUpdateP2P(cache.getP2PUpdates(), false, 2, null), (EntityPlayerMP)player);
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                }
                scheduledThreadPoolExecutor.schedule(new Runnable(cache, playerState, player){
                    final /* synthetic */ GridServerCache $cache;
                    final /* synthetic */ PlayerRequest $playerState;
                    final /* synthetic */ EntityPlayer $player$inlined;
                    {
                        this.$cache = gridServerCache;
                        this.$playerState = playerRequest;
                        this.$player$inlined = entityPlayer;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        Map<UUID, PlayerRequest> map = ModNetwork.INSTANCE.getPlayerState();
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (map) {
                            boolean bl3 = false;
                            EntityPlayer entityPlayer = this.$player$inlined;
                            if (entityPlayer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                            }
                            ModNetwork.INSTANCE.getChannel().sendTo((IMessage)new S2CUpdateP2P(this.$cache.getP2PUpdates(), false, 2, null), (EntityPlayerMP)entityPlayer);
                            this.$playerState.setUpdatePending$betterp2p(false);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }, playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initConnection(@NotNull EntityPlayer player, @NotNull IGrid grid, @NotNull MemoryInfo info2) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)grid, (String)"grid");
        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
        GridServerCache cache = new GridServerCache(grid, player, info2.getType());
        UUID uUID = player.func_110124_au();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"player.uniqueID");
        playerState.put(uUID, new PlayerRequest(false, 0L, cache, 3, null));
        channel.sendTo((IMessage)new S2COpenGui(cache.retrieveP2PList(), info2), (EntityPlayerMP)player);
    }

    public final void removeConnection(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        playerState.remove(player.func_110124_au());
    }

    public final void stop() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
        if (scheduledThreadPoolExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
        }
        scheduledThreadPoolExecutor.shutdown();
    }

    private ModNetwork() {
    }

    static {
        ModNetwork modNetwork;
        INSTANCE = modNetwork = new ModNetwork();
        SimpleNetworkWrapper simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("betterp2p");
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleNetworkWrapper, (String)"NetworkRegistry.INSTANCE.newSimpleChannel(MODID)");
        channel = simpleNetworkWrapper;
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronizedMap(WeakHashMap())");
        playerState = map;
    }
}

