/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.item;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.util.AEPartLocation;
import appeng.core.CreativeTab;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.client.ClientCache;
import com.projecturanus.betterp2p.client.gui.widget.GuiScale;
import com.projecturanus.betterp2p.item.BetterMemoryCardModes;
import com.projecturanus.betterp2p.network.ModNetwork;
import com.projecturanus.betterp2p.network.data.MemoryInfo;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import com.projecturanus.betterp2p.util.CableBusUtilKt;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u0004H\u0003J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016JH\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0016J0\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0010H\u0016J\u0016\u0010/\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0019\u00a8\u00061"}, d2={"Lcom/projecturanus/betterp2p/item/ItemAdvancedMemoryCard;", "Lnet/minecraft/item/Item;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "clearClientCache", "doesSneakBypassUse", "", "itemstack", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getInfo", "Lcom/projecturanus/betterp2p/network/data/MemoryInfo;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "w", "hand", "side", "Lnet/minecraft/util/EnumFacing;", "hx", "", "hy", "hz", "onUpdate", "entityIn", "Lnet/minecraft/entity/Entity;", "itemSlot", "", "isSelected", "writeInfo", "info", "betterp2p"})
public final class ItemAdvancedMemoryCard
extends Item {
    public static final ItemAdvancedMemoryCard INSTANCE;

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        MemoryInfo info2 = this.getInfo(stack);
        Collection collection = tooltip;
        String string = info2.getMode().name();
        StringBuilder stringBuilder = new StringBuilder().append("gui.advanced_memory_card.mode.");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        string = I18n.func_135052_a((String)stringBuilder.append(string4).toString(), (Object[])new Object[0]);
        bl = false;
        collection.add(string);
    }

    @SideOnly(value=Side.CLIENT)
    private final void clearClientCache() {
        ClientCache.INSTANCE.clear();
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        if (playerIn.func_70093_af() && worldIn.field_72995_K) {
            this.clearClientCache();
        }
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
        return actionResult;
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World w, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing side, float hx, float hy, float hz) {
        TileEntity te;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (!w.field_72995_K && (te = w.func_175625_s(pos)) instanceof IGridHost && ((IGridHost)te).getGridNode(AEPartLocation.fromFacing((EnumFacing)side)) != null) {
            ItemStack stack;
            IPart part = CableBusUtilKt.getPart((IBlockAccess)w, pos, hx, hy, hz);
            IPart iPart = part;
            if (iPart == null || (iPart = iPart.getGridNode()) == null || (iPart = iPart.getGrid()) == null) {
                return EnumActionResult.FAIL;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iPart, (String)"part?.gridNode?.grid ?: \u2026urn EnumActionResult.FAIL");
            IPart grid = iPart;
            if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
                return EnumActionResult.FAIL;
            }
            ItemStack itemStack = stack = player.func_184586_b(hand);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            MemoryInfo info2 = this.getInfo(itemStack);
            int type = 0;
            if (part instanceof PartP2PTunnel) {
                type = P2PUtilKt.getTypeIndex((PartP2PTunnel)part);
                info2.setSelectedEntry(P2PLocationKt.toLoc((PartP2PTunnel)part));
            } else {
                type = -1;
                info2.setSelectedEntry(null);
            }
            info2.setType(type);
            this.writeInfo(stack, info2);
            ModNetwork.INSTANCE.initConnection(player, (IGrid)grid, info2);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack itemstack, @Nullable IBlockAccess world, @Nullable BlockPos pos, @Nullable EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        return true;
    }

    @NotNull
    public final MemoryInfo getInfo(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)this)) ^ true) {
            throw (Throwable)new ClassCastException("Cannot cast " + stack.func_77973_b().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
        NBTTagCompound compound = nBTTagCompound;
        if (!compound.func_74764_b("gui")) {
            compound.func_74774_a("gui", (byte)GuiScale.DYNAMIC.ordinal());
        }
        if (!compound.func_150297_b("selectedIndex", 10)) {
            compound.func_74782_a("selectedIndex", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound2 = compound.func_74775_l("selectedIndex");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"compound.getCompoundTag(\"selectedIndex\")");
        return new MemoryInfo(P2PLocationKt.readP2PLocation(nBTTagCompound2), compound.func_74765_d("frequency"), BetterMemoryCardModes.values()[compound.func_74762_e("mode")], GuiScale.values()[compound.func_74771_c("gui")], 0, 16, null);
    }

    public final void writeInfo(@NotNull ItemStack stack, @NotNull MemoryInfo info2) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
        if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)((Object)this)) ^ true) {
            throw (Throwable)new ClassCastException("Cannot cast " + stack.func_77973_b().getClass().getName() + " to " + ((Object)((Object)this)).getClass().getName());
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
        NBTTagCompound compound = nBTTagCompound;
        compound.func_74782_a("selectedIndex", (NBTBase)P2PLocationKt.writeP2PLocation(info2.getSelectedEntry()));
        compound.func_74777_a("frequency", info2.getFrequency());
        compound.func_74768_a("mode", info2.getMode().ordinal());
        compound.func_74774_a("gui", (byte)info2.getGuiScale().ordinal());
    }

    private ItemAdvancedMemoryCard() {
    }

    static {
        ItemAdvancedMemoryCard itemAdvancedMemoryCard;
        INSTANCE = itemAdvancedMemoryCard = new ItemAdvancedMemoryCard();
        itemAdvancedMemoryCard.field_77777_bU = 1;
        itemAdvancedMemoryCard.func_77655_b("advanced_memory_card");
        itemAdvancedMemoryCard.func_77637_a((CreativeTabs)CreativeTab.instance);
    }
}

