/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.parts.p2p.PartP2PFEPower;
import appeng.parts.p2p.PartP2PFluids;
import appeng.parts.p2p.PartP2PGTCEPower;
import appeng.parts.p2p.PartP2PIC2Power;
import appeng.parts.p2p.PartP2PItems;
import appeng.parts.p2p.PartP2PLight;
import appeng.parts.p2p.PartP2PRedstone;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelME;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0005J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J,\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0012\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001a0\nH\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/projecturanus/betterp2p/CommonProxy;", "", "()V", "tunnelIndices", "", "", "Lcom/projecturanus/betterp2p/util/p2p/TunnelInfo;", "getTunnelIndices", "()Ljava/util/Map;", "tunnelTypes", "Ljava/lang/Class;", "getTunnelTypes", "getP2PFromClass", "clazz", "getP2PFromIndex", "index", "getP2PTypeList", "", "initTunnels", "", "postInit", "registerTunnel", "def", "Lappeng/api/definitions/IItemDefinition;", "type", "classType", "Lappeng/parts/p2p/PartP2PTunnel;", "betterp2p"})
public class CommonProxy {
    @NotNull
    private final Map<Class<?>, TunnelInfo> tunnelTypes;
    @NotNull
    private final Map<Integer, TunnelInfo> tunnelIndices;

    @NotNull
    protected final Map<Class<?>, TunnelInfo> getTunnelTypes() {
        return this.tunnelTypes;
    }

    @NotNull
    protected final Map<Integer, TunnelInfo> getTunnelIndices() {
        return this.tunnelIndices;
    }

    public void postInit() {
        this.initTunnels();
    }

    public void initTunnels() {
        IParts partDefs = AEApi.instance().definitions().parts();
        int typeId = 0;
        IItemDefinition iItemDefinition = partDefs.p2PTunnelME();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition, (String)"partDefs.p2PTunnelME()");
        this.registerTunnel(iItemDefinition, typeId++, PartP2PTunnelME.class);
        IItemDefinition iItemDefinition2 = partDefs.p2PTunnelEU();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition2, (String)"partDefs.p2PTunnelEU()");
        this.registerTunnel(iItemDefinition2, typeId++, PartP2PIC2Power.class);
        IItemDefinition iItemDefinition3 = partDefs.p2PTunnelFE();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition3, (String)"partDefs.p2PTunnelFE()");
        this.registerTunnel(iItemDefinition3, typeId++, PartP2PFEPower.class);
        IItemDefinition iItemDefinition4 = partDefs.p2PTunnelRedstone();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition4, (String)"partDefs.p2PTunnelRedstone()");
        this.registerTunnel(iItemDefinition4, typeId++, PartP2PRedstone.class);
        IItemDefinition iItemDefinition5 = partDefs.p2PTunnelFluids();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition5, (String)"partDefs.p2PTunnelFluids()");
        this.registerTunnel(iItemDefinition5, typeId++, PartP2PFluids.class);
        IItemDefinition iItemDefinition6 = partDefs.p2PTunnelItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition6, (String)"partDefs.p2PTunnelItems()");
        this.registerTunnel(iItemDefinition6, typeId++, PartP2PItems.class);
        IItemDefinition iItemDefinition7 = partDefs.p2PTunnelLight();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition7, (String)"partDefs.p2PTunnelLight()");
        this.registerTunnel(iItemDefinition7, typeId++, PartP2PLight.class);
        IItemDefinition iItemDefinition8 = partDefs.p2PTunnelGTEU();
        Intrinsics.checkExpressionValueIsNotNull((Object)iItemDefinition8, (String)"partDefs.p2PTunnelGTEU()");
        this.registerTunnel(iItemDefinition8, typeId++, PartP2PGTCEPower.class);
    }

    private final void registerTunnel(IItemDefinition def, int type, Class<? extends PartP2PTunnel<?>> classType) {
        if (def.isEnabled()) {
            Object t = def.maybeStack(1).get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"def.maybeStack(1).get()");
            ItemStack stack = (ItemStack)t;
            TunnelInfo info2 = new TunnelInfo(type, stack, classType);
            this.tunnelTypes.put(classType, info2);
            this.tunnelIndices.put(type, info2);
        }
    }

    @Nullable
    public final TunnelInfo getP2PFromIndex(int index) {
        return this.tunnelIndices.get(index);
    }

    @Nullable
    public final TunnelInfo getP2PFromClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.tunnelTypes.get(clazz);
    }

    @NotNull
    public final List<TunnelInfo> getP2PTypeList() {
        return CollectionsKt.toList((Iterable)this.tunnelIndices.values());
    }

    public CommonProxy() {
        Map map;
        CommonProxy commonProxy = this;
        boolean bl = false;
        commonProxy.tunnelTypes = map = (Map)new LinkedHashMap();
        commonProxy = this;
        bl = false;
        commonProxy.tunnelIndices = map = (Map)new LinkedHashMap();
    }
}

