/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;

public class ReflectionCache {
    private final HashMap<String, Method> methods = new HashMap();
    private final HashMap<String, Field> fields = new HashMap();

    public Object invokeMethod(Object obj, String name, Object ... args) throws InvocationTargetException {
        Method method = this.methods.get(name);
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invoking method in MouseTweaks' reflection");
            throw new ReportedException(crashreport);
        }
    }

    public Object getFieldValue(Object obj, String name) {
        Field field = this.fields.get(name);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Getting field value in MouseTweaks' reflection");
            throw new ReportedException(crashreport);
        }
    }

    public void setFieldValue(Object obj, String name, Object value) {
        Field field = this.fields.get(name);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Setting field value in MouseTweaks' reflection");
            throw new ReportedException(crashreport);
        }
    }

    void storeMethod(String name, Method method) {
        this.methods.put(name, method);
    }

    void storeField(String name, Field field) {
        this.fields.put(name, field);
    }
}

