/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.texteditor;

import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class TextEditorFrame
extends JFrame {
    private static BufferedImage logo;
    public final Quest quest;
    private final String originalTitle;
    private final String originalSubtitle;
    private final String originalDescription;
    public final JTextField title;
    public final JTextField subtitle;
    public final JTextArea description;
    public final JButton save;
    public final JButton reset;

    public static void open(Quest quest) {
        new TextEditorFrame(quest).requestFocus();
    }

    private TextEditorFrame(Quest q) {
        super("FTB Quests Text Editor | " + q.chapter.getTitle() + " | " + q.getTitle());
        this.quest = q;
        this.originalTitle = this.quest.title;
        this.originalSubtitle = this.quest.subtitle;
        this.originalDescription = String.join((CharSequence)"\n", this.quest.description);
        if (logo == null) {
            try (InputStream stream2 = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ftbquests", "textures/logotransparent.png")).func_110527_b();){
                logo = ImageIO.read(stream2);
            }
            catch (Exception stream2) {
                // empty catch block
            }
        }
        if (logo != null) {
            this.setIconImage(logo);
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.title = new JTextField(this.originalTitle, 75);
        panel.add(this.title);
        this.subtitle = new JTextField(this.originalSubtitle, 75);
        panel.add(this.subtitle);
        this.description = new JTextArea(this.originalDescription, 30, 75);
        panel.add(this.description);
        this.title.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), I18n.func_135052_a((String)"ftbquests.title", (Object[])new Object[0])));
        this.subtitle.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), I18n.func_135052_a((String)"ftbquests.quest.subtitle", (Object[])new Object[0])));
        this.description.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), I18n.func_135052_a((String)"ftbquests.quest.description", (Object[])new Object[0])));
        JPanel buttonPanel = new JPanel();
        this.reset = new JButton("Reset");
        buttonPanel.add(this.reset);
        this.save = new JButton("Save");
        buttonPanel.add(this.save);
        this.reset.addActionListener(this::resetClicked);
        this.save.addActionListener(this::saveClicked);
        panel.add(buttonPanel);
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void resetClicked(ActionEvent event) {
        this.title.setText(this.originalTitle);
        this.subtitle.setText(this.originalSubtitle);
        this.description.setText(this.originalDescription);
    }

    private void saveClicked(ActionEvent event) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            this.quest.title = this.title.getText().trim();
            this.quest.subtitle = this.subtitle.getText().trim();
            this.quest.description.clear();
            this.quest.description.addAll(Arrays.asList(this.description.getText().split("\n")));
            this.quest.clearCachedData();
            this.setTitle("FTB Quests Text Editor | " + this.quest.chapter.getTitle() + " | " + this.quest.getTitle());
            new MessageEditObject(this.quest).sendToServer();
        });
    }
}

