/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Task
extends QuestObject {
    public final Quest quest;

    public Task(Quest q) {
        this.quest = q;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.TASK;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract TaskType getType();

    public abstract TaskData createData(QuestData var1);

    @Override
    public final int getRelativeProgressFromChildren(QuestData data) {
        return data.getTaskData(this).getRelativeProgress();
    }

    @Override
    public final void onCompleted(QuestData data, List<EntityPlayerMP> onlineMembers, List<EntityPlayerMP> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        new ObjectCompletedEvent.TaskEvent(data, this, onlineMembers, notifiedPlayers).post();
        boolean questComplete = this.quest.isComplete(data);
        if (this.quest.tasks.size() > 1 && !questComplete && !this.disableToast) {
            new MessageDisplayCompletionToast(this.id).sendTo(notifiedPlayers);
        }
        if (questComplete) {
            this.quest.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    public long getMaxProgress() {
        return 1L;
    }

    public String getMaxProgressString() {
        return StringUtils.formatDouble((double)this.getMaxProgress(), (boolean)true);
    }

    @Override
    public final void changeProgress(QuestData data, ChangeProgress type) {
        data.getTaskData(this).setProgress(type.reset ? 0L : this.getMaxProgress());
    }

    @Override
    public final void deleteSelf() {
        this.quest.tasks.remove(this);
        for (QuestData questData : this.quest.chapter.file.getAllData()) {
            questData.removeTask(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (QuestData questData : this.quest.chapter.file.getAllData()) {
            questData.removeTask(this);
        }
        super.deleteChildren();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    @Override
    public final void onCreated() {
        this.quest.tasks.add(this);
        for (QuestData questData : this.quest.chapter.file.getAllData()) {
            questData.createTaskData(this);
        }
        if (this instanceof CustomTask) {
            new CustomTaskEvent((CustomTask)this).post();
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public String getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        TaskType type = this.getType();
        return group.getGroup(this.getObjectType().getId()).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    public Class<? extends TileTaskScreenCore> getScreenCoreClass() {
        return TileTaskScreenCore.class;
    }

    public Class<? extends TileTaskScreenPart> getScreenPartClass() {
        return TileTaskScreenPart.class;
    }

    public TileTaskScreenCore createScreenCore(World world) {
        return new TileTaskScreenCore();
    }

    public TileTaskScreenPart createScreenPart(World world) {
        return new TileTaskScreenPart();
    }

    public void drawGUI(@Nullable TaskData data, int x, int y, int w, int h) {
        this.getIcon().draw(x, y, w, h);
    }

    public void drawScreen(@Nullable TaskData data) {
        this.getIcon().draw3D();
    }

    public boolean canInsertItem() {
        return false;
    }

    public boolean consumesResources() {
        return this.canInsertItem();
    }

    public boolean hideProgressNumbers() {
        return this.getMaxProgress() <= 1L;
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable TaskData data) {
        if (this.consumesResources()) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.click_to_submit", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        if (canClick && this.autoSubmitOnPlayerTick() <= 0) {
            GuiHelper.playClickSound();
            new MessageSubmitTask(this.id).sendToServer();
        }
    }

    public boolean submitItemsOnInventoryChange() {
        return false;
    }

    @Nullable
    public Object getIngredient() {
        if (this.addTitleInMouseOverText()) {
            return this.getIcon().getIngredient();
        }
        return new WrappedIngredient(this.getIcon().getIngredient()).tooltip();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @SideOnly(value=Side.CLIENT)
    public String getButtonText() {
        return this.getMaxProgress() > 1L || this.consumesResources() ? this.getMaxProgressString() : "";
    }

    public int autoSubmitOnPlayerTick() {
        return 0;
    }

    @Override
    public boolean cacheProgress() {
        return false;
    }
}

