/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancementReward
extends Reward {
    public String advancement = "";
    public String criterion = "";

    public AdvancementReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.ADVANCEMENT;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("advancement", this.advancement);
        nbt.func_74778_a("criterion", this.criterion);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.advancement = nbt.func_74779_i("advancement");
        this.criterion = nbt.func_74779_i("criterion");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.advancement);
        data.writeString(this.criterion);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.advancement = data.readString();
        this.criterion = data.readString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("advancement", () -> this.advancement, v -> {
            this.advancement = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.advancement", new Object[0]));
        config.addString("criterion", () -> this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        Advancement a = player.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation(this.advancement));
        if (a != null) {
            if (this.criterion.isEmpty()) {
                for (String s : a.func_192073_f().keySet()) {
                    player.func_192039_O().func_192750_a(a, s);
                }
            } else {
                player.func_192039_O().func_192750_a(a, this.criterion);
            }
        }
    }

    @Override
    public String getAltTitle() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        if (a != null && a.func_192068_c() != null) {
            return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.advancement", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + a.func_192068_c().func_192297_a().func_150254_d();
        }
        return super.getAltTitle();
    }

    @Override
    public Icon getAltIcon() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        if (a != null && a.func_192068_c() != null) {
            return ItemIcon.getItemIcon((ItemStack)a.func_192068_c().func_192298_b());
        }
        return super.getAltIcon();
    }
}

