/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.reskillable;

import codersafterdark.reskillable.api.event.LevelUpEvent;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.integration.reskillable.ReskillableTask;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReskillableItegration {
    public static TaskType RESKILLABLE_TASK;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(ReskillableItegration.class);
    }

    @SubscribeEvent
    public static void registerTasks(RegistryEvent.Register<TaskType> event) {
        RESKILLABLE_TASK = ((TaskType)new TaskType(ReskillableTask::new).setRegistryName("reskillable")).setIcon(Icon.getIcon((String)ReskillableTask.RESKILLABLE_TEXTURE.toString()));
        event.getRegistry().register((IForgeRegistryEntry)RESKILLABLE_TASK);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ReskillableItegration.checkSkills((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onLevelUp(LevelUpEvent.Post event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            ReskillableItegration.checkSkills((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    private static void checkSkills(EntityPlayerMP player) {
        QuestData data;
        QuestData questData = data = ServerQuestFile.INSTANCE == null ? null : ServerQuestFile.INSTANCE.getData((Entity)player);
        if (data != null) {
            for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.canStartTasks(data)) continue;
                    for (Task task : quest.tasks) {
                        if (!(task instanceof ReskillableTask)) continue;
                        data.getTaskData(task).submitTask(player);
                    }
                }
            }
        }
    }
}

