/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.kubejs;

import com.feed_the_beast.ftbquests.events.CustomRewardEvent;
import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.events.TaskStartedEvent;
import com.feed_the_beast.ftbquests.integration.kubejs.CustomRewardEventJS;
import com.feed_the_beast.ftbquests.integration.kubejs.CustomTaskEventJS;
import com.feed_the_beast.ftbquests.integration.kubejs.FTBQuestsKubeJSPlayerData;
import com.feed_the_beast.ftbquests.integration.kubejs.FTBQuestsKubeJSWrapper;
import com.feed_the_beast.ftbquests.integration.kubejs.QuestObjectCompletedEventJS;
import com.feed_the_beast.ftbquests.integration.kubejs.TaskStartedEventJS;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import dev.latvian.kubejs.documentation.DocumentationEvent;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.event.EventsJS;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.DataType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KubeJSIntegration {
    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(KubeJSIntegration.class);
    }

    @SubscribeEvent
    public static void registerDocumentation(DocumentationEvent event) {
        event.registerAttachedData(DataType.PLAYER, "ftbquests", FTBQuestsKubeJSPlayerData.class);
        event.registerEvent("ftbquests.custom_task", CustomTaskEventJS.class).doubleParam("id").canCancel();
        event.registerEvent("ftbquests.custom_reward", CustomRewardEventJS.class).doubleParam("id").canCancel();
        event.registerEvent("ftbquests.completed", QuestObjectCompletedEventJS.class).doubleParam("id|tag");
        event.registerEvent("ftbquests.started", TaskStartedEventJS.class).doubleParam("id|tag");
    }

    @SubscribeEvent
    public static void registerBindings(BindingsEvent event) {
        event.add("ftbquests", (Object)new FTBQuestsKubeJSWrapper());
    }

    @SubscribeEvent
    public static void attachPlayerData(AttachPlayerDataEvent event) {
        event.add("ftbquests", (Object)new FTBQuestsKubeJSPlayerData((PlayerDataJS)event.getParent()));
    }

    @SubscribeEvent
    public static void onCustomTask(CustomTaskEvent event) {
        if (EventsJS.postDouble((String)"ftbquests.custom_task", (String)event.getTask().toString(), (EventJS)new CustomTaskEventJS(event))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCustomReward(CustomRewardEvent event) {
        if (EventsJS.postDouble((String)"ftbquests.custom_reward", (String)event.getReward().toString(), (EventJS)new CustomRewardEventJS(event))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCompleted(ObjectCompletedEvent event) {
        QuestObjectCompletedEventJS e = new QuestObjectCompletedEventJS(event);
        EventsJS.postDouble((String)"ftbquests.completed", (String)((QuestObjectBase)event.getObject()).toString(), (EventJS)e);
        for (String tag : ((QuestObjectBase)event.getObject()).getTags()) {
            EventsJS.post((String)("ftbquests.completed." + tag), (EventJS)e);
        }
    }

    @SubscribeEvent
    public static void onTaskStarted(TaskStartedEvent event) {
        TaskStartedEventJS e = new TaskStartedEventJS(event);
        EventsJS.postDouble((String)"ftbquests.started", (String)((QuestObjectBase)event.getTaskData().task).toString(), (EventJS)e);
        for (String tag : ((QuestObjectBase)event.getTaskData().task).getTags()) {
            EventsJS.post((String)("ftbquests.started." + tag), (EventJS)e);
        }
    }
}

