/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.kubejs;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import dev.latvian.kubejs.documentation.DisplayName;
import dev.latvian.kubejs.documentation.Info;
import dev.latvian.kubejs.documentation.P;
import dev.latvian.kubejs.documentation.T;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;

@DisplayName(value="FTB Quests Integration")
public class FTBQuestsKubeJSWrapper {
    public Map<String, QuestShape> getQuestShapes() {
        return QuestShape.MAP;
    }

    public Map<String, QuestObjectType> getQuestObjectTypes() {
        return QuestObjectType.NAME_MAP.map;
    }

    public Map<String, ChangeProgress> getChangeProgressTypes() {
        return ChangeProgress.NAME_MAP.map;
    }

    @Info(value="Currently loaded quest file. Can be null")
    public QuestFile getFile(@P(value="world") WorldJS world) {
        QuestFile f = FTBQuests.PROXY.getQuestFile(world.minecraftWorld);
        if (f == null) {
            throw new NullPointerException("Quest file isn't loaded!");
        }
        return f;
    }

    @Nullable
    @Info(value="Quest data from team UID")
    public QuestData getData(@P(value="world") WorldJS world, @P(value="team") @T(value=int.class) Number team) {
        return this.getFile(world).getData(team.intValue());
    }

    @Nullable
    @Info(value="Quest data from team ID")
    public QuestData getData(@P(value="world") WorldJS world, @P(value="team") String team) {
        return this.getFile(world).getData(team);
    }

    @Nullable
    @Info(value="Quest data from player")
    public QuestData getData(@P(value="player") PlayerJS player) {
        return this.getFile(player.getWorld()).getData((Entity)player.minecraftPlayer);
    }

    @Nullable
    @Info(value="Quest object from object UID")
    public QuestObjectBase getObject(@P(value="world") WorldJS world, @P(value="id") Object id) {
        QuestFile file = this.getFile(world);
        return file.getBase(file.getID(id));
    }
}

