/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.IRewardListenerGui;
import com.feed_the_beast.ftbquests.gui.RewardKey;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiRewardNotifications
extends GuiBase
implements IRewardListenerGui {
    public final Object2IntOpenHashMap<RewardKey> rewards = new Object2IntOpenHashMap();
    private final SimpleTextButton closeButton = new SimpleTextButton((Panel)this, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]), (Icon)Icon.EMPTY){

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.getGui().closeGui();
        }
    };
    private final Panel itemPanel = new Panel((Panel)this){

        public void addWidgets() {
            ArrayList keys = new ArrayList(GuiRewardNotifications.this.rewards.keySet());
            keys.sort((o1, o2) -> Integer.compare(GuiRewardNotifications.this.rewards.getInt(o2), GuiRewardNotifications.this.rewards.getInt(o1)));
            for (RewardKey key : keys) {
                this.add(new RewardNotification(this, key));
            }
        }

        public void alignWidgets() {
            if (this.widgets.size() < 9) {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(0, 1, 0)));
                this.setHeight(22);
            } else {
                this.setWidth(207);
                this.setHeight(23 * MathHelper.func_76123_f((float)((float)this.widgets.size() / 9.0f)));
                for (int i = 0; i < this.widgets.size(); ++i) {
                    ((Widget)this.widgets.get(i)).setPos(i % 9 * 23, i / 9 * 23);
                }
            }
            this.setPos((GuiRewardNotifications.this.width - ((GuiRewardNotifications)GuiRewardNotifications.this).itemPanel.width) / 2, (GuiRewardNotifications.this.height - ((GuiRewardNotifications)GuiRewardNotifications.this).itemPanel.height) / 2);
        }
    };

    public GuiRewardNotifications() {
        this.itemPanel.setOnlyRenderWidgetsInside(false);
        this.itemPanel.setUnicode(true);
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.closeButton);
        this.closeButton.setPos((this.width - this.closeButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((int)((float)w / 2.0f)), (float)((int)((float)h / 5.0f)), (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        String s = I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]);
        theme.drawString(s, -theme.getStringWidth(s) / 2, 0, Color4I.WHITE, 0);
        GlStateManager.func_179121_F();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    @Override
    public void rewardReceived(RewardKey key, int count) {
        this.rewards.put((Object)key, this.rewards.getInt((Object)key) + count);
        this.itemPanel.refreshWidgets();
    }

    private class RewardNotification
    extends Widget {
        private final RewardKey key;

        public RewardNotification(Panel p, RewardKey e) {
            super(p);
            this.setSize(22, 22);
            this.key = e;
        }

        public void addMouseOverText(List<String> list) {
            if (!this.key.title.isEmpty()) {
                list.add(this.key.title);
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            QuestShape.get((String)"rsquare").outline.draw(x, y, w, h);
            this.key.icon.draw(x + 3, y + 3, 16, 16);
            int count = GuiRewardNotifications.this.rewards.getInt((Object)this.key);
            if (count > 1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)600.0f);
                String s = StringUtils.formatDouble((double)count, (boolean)true);
                theme.drawString(TextFormatting.YELLOW + s, x + 22 - theme.getStringWidth(s), y + 12, 2);
                GlStateManager.func_179121_F();
            }
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.key.icon.getIngredient()).tooltip();
        }
    }
}

