/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemNBTUtils {
    public static boolean hasTag(@Nonnull ItemStack stack) {
        return stack.func_77942_o();
    }

    public static void setTag(@Nonnull ItemStack stack, NBTTagCompound tagCompound) {
        stack.func_77982_d(tagCompound);
    }

    public static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        return stack.func_77978_p();
    }

    public static NBTTagCompound validateTagExists(@Nonnull ItemStack stack) {
        if (!ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.setTag(stack, new NBTTagCompound());
        }
        return ItemNBTUtils.getTag(stack);
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String key) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).func_74764_b(key);
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String key, int nbtType) {
        return ItemNBTUtils.hasTag(stack) && ItemNBTUtils.getTag(stack).func_150297_b(key, nbtType);
    }

    public static void removeTag(@Nonnull ItemStack stack, String key) {
        if (ItemNBTUtils.hasTag(stack)) {
            ItemNBTUtils.getTag(stack).func_82580_o(key);
        }
    }

    public static void setByte(@Nonnull ItemStack stack, String key, byte b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74774_a(key, b);
    }

    public static void setShort(@Nonnull ItemStack stack, String key, short s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74777_a(key, s);
    }

    public static void setInteger(@Nonnull ItemStack stack, String key, int i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74768_a(key, i);
    }

    public static void setLong(@Nonnull ItemStack stack, String key, long l) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74772_a(key, l);
    }

    public static void setUUID(@Nonnull ItemStack stack, String key, UUID uuid) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_186854_a(key, uuid);
    }

    public static void setFloat(@Nonnull ItemStack stack, String key, float f) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74776_a(key, f);
    }

    public static void setDouble(@Nonnull ItemStack stack, String key, double d) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74780_a(key, d);
    }

    public static void setString(@Nonnull ItemStack stack, String key, String s) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74778_a(key, s);
    }

    public static void setByteArray(@Nonnull ItemStack stack, String key, byte[] b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74773_a(key, b);
    }

    public static void setIntArray(@Nonnull ItemStack stack, String key, int[] i) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74783_a(key, i);
    }

    public static void setBoolean(@Nonnull ItemStack stack, String key, boolean b) {
        ItemNBTUtils.validateTagExists(stack);
        ItemNBTUtils.getTag(stack).func_74757_a(key, b);
    }

    public static byte getByte(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74771_c(key);
    }

    public static short getShort(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74765_d(key);
    }

    public static int getInteger(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74762_e(key);
    }

    public static long getLong(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74763_f(key);
    }

    public static UUID getUUID(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_186857_a(key);
    }

    public static float getFloat(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74760_g(key);
    }

    public static double getDouble(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74769_h(key);
    }

    public static String getString(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74779_i(key);
    }

    public static byte[] getByteArray(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74770_j(key);
    }

    public static int[] getIntArray(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74759_k(key);
    }

    public static boolean getBoolean(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74767_n(key);
    }

    public static NBTTagCompound getCompoundTag(@Nonnull ItemStack stack, String key) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_74775_l(key);
    }

    public static NBTTagList getTagList(@Nonnull ItemStack stack, String key, int type) {
        ItemNBTUtils.validateTagExists(stack);
        return ItemNBTUtils.getTag(stack).func_150295_c(key, type);
    }
}

