/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.item;

import codechicken.lib.internal.CCLLog;
import codechicken.lib.internal.ExceptionMessageEventHandler;
import codechicken.lib.internal.proxy.ProxyClient;
import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.util.LambdaUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class CCRenderItem
extends RenderItem {
    private final RenderItem parent;
    private static CCRenderItem instance;
    private static boolean hasInit;
    private static final Matrix4f flipX;
    private ItemCameraTransforms.TransformType lastKnownTransformType;
    private static Map<IRegistryDelegate<Item>, Int2ObjectMap<ModelResourceLocation>> immf_locationsCache;
    private static Map<IRegistryDelegate<Item>, Int2ObjectMap<IBakedModel>> immf_modelsCache;
    private static Map<Item, ItemMeshDefinition> imm_shapersCache;
    public static long lastTime;

    public CCRenderItem(RenderItem renderItem) {
        super(renderItem.field_175057_n, renderItem.field_175059_m.func_178083_a(), renderItem.field_184395_f);
        this.parent = renderItem;
    }

    public static void init() {
        if (!hasInit) {
            instance = new CCRenderItem(Minecraft.func_71410_x().func_175599_af());
            ObfMapping mapping = new ObfMapping("net/minecraft/client/Minecraft", "field_175621_X", "");
            ReflectionManager.setField(mapping, Minecraft.func_71410_x(), (Object)instance);
            hasInit = true;
        }
    }

    public static RenderItem getOverridenRenderItem() {
        CCRenderItem.init();
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static void notifyTransform(ItemCameraTransforms.TransformType transformType) {
        CCRenderItem.instance.lastKnownTransformType = transformType;
    }

    public static ModelResourceLocation getModelForStack(ItemStack stack) {
        CCRenderItem.pullCache();
        Item item = stack.func_77973_b();
        if (stack.func_190926_b() || item == null) {
            return ModelBakery.field_177604_a;
        }
        ModelResourceLocation loc = null;
        if (immf_modelsCache.containsKey(item.delegate)) {
            loc = (ModelResourceLocation)immf_locationsCache.get(item.delegate).get(stack.func_77958_k() > 0 ? 0 : stack.func_77960_j());
        } else {
            ItemMeshDefinition mesher = imm_shapersCache.get(item);
            if (mesher != null) {
                loc = mesher.func_178113_a(stack);
            }
        }
        if (loc == null) {
            loc = ModelBakery.field_177604_a;
        }
        return loc;
    }

    private static void pullCache() {
        try {
            if (immf_locationsCache == null || immf_modelsCache == null || imm_shapersCache == null) {
                RenderItem renderItem = CCRenderItem.getOverridenRenderItem();
                ItemModelMesher mesher = renderItem.func_175037_a();
                String cls = ItemModelMesherForge.class.getName().replace(".", "/");
                String cls2 = ItemModelMesher.class.getName().replace(".", "/");
                ObfMapping locationsMapping = new ObfMapping(cls, "locations", "Ljava/util/Map;");
                ObfMapping modelsMapping = new ObfMapping(cls, "locations", "Ljava/util/Map;");
                ObfMapping shapersField = new ObfMapping(cls2, "field_178092_c", "Ljava/util/Map;");
                immf_locationsCache = ReflectionManager.getField(locationsMapping, mesher, Map.class);
                immf_modelsCache = ReflectionManager.getField(modelsMapping, mesher, Map.class);
                imm_shapersCache = ReflectionManager.getField(shapersField, mesher, Map.class);
            }
        }
        catch (Exception e) {
            CCLLog.log(Level.ERROR, e, (Object)"Unable to pull cache.");
            throw new RuntimeException("Unable to update cache, see log.");
        }
    }

    private void handleCaughtException(int startMatrixDepth, Throwable t, ItemStack stack) {
        Item item = stack.func_77973_b();
        StringBuilder builder = new StringBuilder("\nCCL Has caught an exception whilst rendering an item.\n");
        builder.append("  Item Class:     ").append(LambdaUtils.tryOrNull(() -> item.getClass())).append("\n");
        builder.append("  Registry Name:  ").append(LambdaUtils.tryOrNull(() -> item.getRegistryName())).append("\n");
        builder.append("  Metadata:       ").append(stack.func_77960_j()).append("\n");
        builder.append("  NBT:            ").append(LambdaUtils.tryOrNull(() -> stack.func_77978_p())).append("\n");
        builder.append("  Model Class:    ").append(LambdaUtils.tryOrNull(() -> this.field_175059_m.func_178089_a(stack).getClass())).append("\n");
        builder.append("  Model Location: ").append(CCRenderItem.getModelForStack(stack)).append("\n");
        if (ProxyClient.messagePlayerOnRenderExceptionCaught) {
            builder.append("You can turn off player messages in the CCL config file.\n");
        }
        if (ProxyClient.attemptRecoveryOnItemRenderException) {
            int matrixDepth;
            long time;
            builder.append("WARNING: Exception recovery enabled! This may cause issues down the line!\n");
            BufferBuilder vanillaBuffer = Tessellator.func_178181_a().func_178180_c();
            if (vanillaBuffer.field_179010_r) {
                vanillaBuffer.func_178977_d();
            }
            String logMessage = builder.toString();
            String key = ExceptionUtils.getStackTrace((Throwable)t) + logMessage;
            if (!ExceptionMessageEventHandler.exceptionMessageCache.contains(key)) {
                ExceptionMessageEventHandler.exceptionMessageCache.add(key);
                CCLLog.log(Level.ERROR, t, (Object)logMessage);
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (ProxyClient.messagePlayerOnRenderExceptionCaught && player != null && TimeUnit.NANOSECONDS.toSeconds((time = System.nanoTime()) - lastTime) > 5L) {
                lastTime = time;
                player.func_145747_a((ITextComponent)new TextComponentString("CCL Caught an exception rendering an item. See the log for info."));
            }
            if ((matrixDepth = GL11.glGetInteger((int)2979)) != startMatrixDepth) {
                for (int i = matrixDepth; i > startMatrixDepth; --i) {
                    GlStateManager.func_179121_F();
                }
            }
        } else {
            builder.append("If you want CCL to attempt to recover the game next time, enable it in the CCL config.\n");
            String logMessage = builder.toString();
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)t, (String)logMessage);
            CrashReportCategory category = crashReport.func_85058_a("Item being rendered");
            category.func_189529_a("Item Type", () -> String.valueOf(stack.func_77973_b()));
            category.func_189529_a("Item Aux", () -> String.valueOf(stack.func_77960_j()));
            category.func_189529_a("Item NBT", () -> String.valueOf(stack.func_77978_p()));
            category.func_189529_a("Item Foil", () -> String.valueOf(stack.func_77962_s()));
            throw new ReportedException(crashReport);
        }
    }

    public void func_180454_a(ItemStack stack, IBakedModel model) {
        if (!stack.func_190926_b() && model instanceof IItemRenderer) {
            IItemRenderer renderer = (IItemRenderer)model;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateTracker.pushState();
            renderer.renderItem(stack, this.lastKnownTransformType);
            GlStateTracker.popState();
            GlStateManager.func_179121_F();
            return;
        }
        this.parent.func_180454_a(stack, model);
    }

    private IBakedModel handleTransforms(ItemStack stack, IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean isLeftHand) {
        this.lastKnownTransformType = transformType;
        return ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)isLeftHand);
    }

    private boolean isValidModel(IBakedModel model) {
        return model instanceof IItemRenderer;
    }

    public void func_184394_a(ItemStack stack, IBakedModel bakedModel, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!stack.func_190926_b()) {
            if (this.isValidModel(bakedModel)) {
                this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
                this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                bakedModel = this.handleTransforms(stack, bakedModel, transform, leftHanded);
                this.func_180454_a(stack, bakedModel);
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                GlStateManager.func_179121_F();
                GlStateManager.func_179101_C();
                GlStateManager.func_179084_k();
                this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
                this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
            } else {
                this.parent.field_77023_b = this.field_77023_b;
                this.parent.func_184394_a(stack, bakedModel, transform, leftHanded);
            }
        }
    }

    public void func_191962_a(ItemStack stack, int x, int y, IBakedModel bakedModel) {
        if (this.isValidModel(bakedModel)) {
            GlStateManager.func_179094_E();
            this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
            this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_180452_a(x, y, bakedModel.func_177556_c());
            bakedModel = this.handleTransforms(stack, bakedModel, ItemCameraTransforms.TransformType.GUI, false);
            this.func_180454_a(stack, bakedModel);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
            this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        } else {
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_191962_a(stack, x, y, bakedModel);
        }
    }

    public void func_181564_a(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        if (!stack.func_190926_b()) {
            IBakedModel bakedModel = this.func_184393_a(stack, null, null);
            if (this.isValidModel(bakedModel)) {
                this.func_184394_a(stack, bakedModel, cameraTransformType, false);
            }
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_181564_a(stack, cameraTransformType);
        }
    }

    public void func_184392_a(ItemStack stack, EntityLivingBase livingBase, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!stack.func_190926_b() && livingBase != null) {
            IBakedModel bakedModel = this.func_184393_a(stack, livingBase.field_70170_p, livingBase);
            if (this.isValidModel(bakedModel)) {
                this.func_184394_a(stack, bakedModel, transform, leftHanded);
            } else {
                this.parent.field_77023_b = this.field_77023_b;
                this.parent.func_184392_a(stack, livingBase, transform, leftHanded);
            }
        }
    }

    public void func_175042_a(ItemStack stack, int x, int y) {
        IBakedModel bakedModel = this.func_184393_a(stack, null, null);
        if (this.isValidModel(bakedModel)) {
            this.func_191962_a(stack, x, y, bakedModel);
        } else {
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_175042_a(stack, x, y);
        }
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_184391_a(@Nullable EntityLivingBase livingBase, ItemStack stack, int x, int y) {
        if (!stack.func_190926_b()) {
            int matrixDepth = -1;
            if (ProxyClient.attemptRecoveryOnItemRenderException) {
                matrixDepth = GL11.glGetInteger((int)2979);
            }
            try {
                IBakedModel model = this.func_184393_a(stack, null, livingBase);
                if (this.isValidModel(model)) {
                    this.field_77023_b += 50.0f;
                    this.func_191962_a(stack, x, y, model);
                    this.field_77023_b -= 50.0f;
                    return;
                }
            }
            catch (Throwable throwable) {
                if (ProxyClient.catchItemRenderExceptions) {
                    this.handleCaughtException(matrixDepth, throwable, stack);
                    return;
                }
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering IItemRenderer item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", () -> String.valueOf(stack.func_77973_b()));
                crashreportcategory.func_189529_a("Item Aux", () -> String.valueOf(stack.func_77960_j()));
                crashreportcategory.func_189529_a("Item NBT", () -> String.valueOf(stack.func_77978_p()));
                crashreportcategory.func_189529_a("Item Foil", () -> String.valueOf(stack.func_77962_s()));
                throw new ReportedException(crashreport);
            }
            try {
                this.parent.field_77023_b = this.field_77023_b;
                this.parent.func_184391_a(livingBase, stack, x, y);
            }
            catch (Throwable t) {
                if (ProxyClient.catchItemRenderExceptions) {
                    this.handleCaughtException(matrixDepth, t, stack);
                    return;
                }
                throw t;
            }
        }
    }

    public void func_175041_b() {
    }

    public void func_175048_a(Item item, int subType, String identifier) {
        this.parent.func_175048_a(item, subType, identifier);
    }

    public ItemModelMesher func_175037_a() {
        return this.parent.func_175037_a();
    }

    public boolean func_175050_a(ItemStack stack) {
        return this.parent.func_175050_a(stack);
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entitylivingbaseIn) {
        return this.parent.func_184393_a(stack, worldIn, entitylivingbaseIn);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.parent.func_110549_a(resourceManager);
    }

    static {
        lastTime = 0L;
        flipX = new Matrix4f();
        flipX.setIdentity();
        CCRenderItem.flipX.m00 = -1.0f;
    }
}

