/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.colour;

import codechicken.lib.colour.ColourRGBA;
import com.google.common.collect.ImmutableList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Triple;

public enum EnumColour implements IStringSerializable
{
    WHITE("white", "dyeWhite", "blockWoolWhite", "item.fireworksCharge.white", 0xFFFFFF),
    ORANGE("orange", "dyeOrange", "blockWoolOrange", "item.fireworksCharge.orange", 12608256),
    MAGENTA("magenta", "dyeMagenta", "blockWoolMagenta", "item.fireworksCharge.magenta", 11868853),
    LIGHT_BLUE("light_blue", "dyeLightBlue", "blockWoolLightBlue", "item.fireworksCharge.lightBlue", 7308529),
    YELLOW("yellow", "dyeYellow", "blockWoolYellow", "item.fireworksCharge.yellow", 0xBFBF00),
    LIME("lime", "dyeLime", "blockWoolLime", "item.fireworksCharge.lime", 7074048),
    PINK("pink", "dyePink", "blockWoolPink", "item.fireworksCharge.pink", 15812213),
    GRAY("gray", "dyeGray", "blockWoolGray", "item.fireworksCharge.gray", 0x535353),
    LIGHT_GRAY("light_gray", "dyeLightGray", "blockWoolLightGray", "item.fireworksCharge.silver", 0x939393),
    CYAN("cyan", "dyeCyan", "blockWoolCyan", "item.fireworksCharge.cyan", 34695),
    PURPLE("purple", "dyePurple", "blockWoolPurple", "item.fireworksCharge.purple", 6160576),
    BLUE("blue", "dyeBlue", "blockWoolBlue", "item.fireworksCharge.blue", 1250240),
    BROWN("brown", "dyeBrown", "blockWoolBrown", "item.fireworksCharge.brown", 5187328),
    GREEN("green", "dyeGreen", "blockWoolGreen", "item.fireworksCharge.green", 558848),
    RED("red", "dyeRed", "blockWoolRed", "item.fireworksCharge.red", 10620678),
    BLACK("black", "dyeBlack", "blockWoolBlack", "item.fireworksCharge.black", 0x1F1F1F);

    private final String name;
    private final String dyeOreName;
    private final String woolOreName;
    private final String unlocalizedName;
    private final int rgb;
    private static final ImmutableList<Triple<EnumColour, EnumColour, EnumColour>> mixMap;

    private EnumColour(String name, String dyeOreName, String woolOreName, String unlocalizedName, int rgb) {
        this.name = name;
        this.dyeOreName = dyeOreName;
        this.woolOreName = woolOreName;
        this.unlocalizedName = unlocalizedName;
        this.rgb = rgb;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String getDyeOreName() {
        return this.dyeOreName;
    }

    public String getWoolOreName() {
        return this.woolOreName;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public int getWoolMeta() {
        return this.ordinal();
    }

    public int getDyeMeta() {
        return 15 - this.ordinal();
    }

    public int rgba() {
        return this.rgba(255);
    }

    public int rgba(int alpha) {
        return this.rgb << 8 | alpha & 0xFF;
    }

    public int argb() {
        return this.argb(255);
    }

    public int argb(int alpha) {
        return (alpha & 0xFF) << 24 | this.rgb;
    }

    public int rgb() {
        return this.rgb;
    }

    public float rF() {
        return (float)(this.rgb >> 16 & 0xFF) / 255.0f;
    }

    public float gF() {
        return (float)(this.rgb >> 8 & 0xFF) / 255.0f;
    }

    public float bF() {
        return (float)(this.rgb & 0xFF) / 255.0f;
    }

    public ColourRGBA getColour() {
        return this.getColour(255);
    }

    public ColourRGBA getColour(int alpha) {
        return new ColourRGBA(this.rgba(alpha));
    }

    public EnumColour mix(EnumColour b) {
        return EnumColour.mix(this, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumColour mix(EnumColour a, EnumColour b) {
        if (a == b) {
            return a;
        }
        ImmutableList<Triple<EnumColour, EnumColour, EnumColour>> immutableList = mixMap;
        synchronized (immutableList) {
            for (Triple triple : mixMap) {
                if ((!((EnumColour)((Object)triple.getLeft())).equals((Object)a) || !((EnumColour)((Object)triple.getMiddle())).equals((Object)b)) && (!((EnumColour)((Object)triple.getLeft())).equals((Object)b) || !((EnumColour)((Object)triple.getMiddle())).equals((Object)a))) continue;
                return (EnumColour)((Object)triple.getRight());
            }
        }
        return null;
    }

    public static EnumColour fromWoolMeta(int id) {
        return EnumColour.values()[id];
    }

    public static EnumColour fromDyeMeta(int id) {
        return EnumColour.values()[15 - id];
    }

    public static EnumColour fromDyeOre(String id) {
        for (EnumColour c : EnumColour.values()) {
            if (!c.getDyeOreName().equals(id)) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromWoolOre(String id) {
        for (EnumColour c : EnumColour.values()) {
            if (!c.getWoolOreName().equals(id)) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromDyeStack(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            EnumColour c = EnumColour.fromDyeOre(OreDictionary.getOreName((int)id));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromWoolStack(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            EnumColour c = EnumColour.fromWoolOre(OreDictionary.getOreName((int)id));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromName(String name) {
        for (EnumColour colour : EnumColour.values()) {
            if (!colour.func_176610_l().equalsIgnoreCase(name)) continue;
            return colour;
        }
        return null;
    }

    private static Triple<EnumColour, EnumColour, EnumColour> getTriple(EnumColour a, EnumColour b, EnumColour result) {
        return Triple.of((Object)((Object)a), (Object)((Object)b), (Object)((Object)result));
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(EnumColour.getTriple(YELLOW, RED, ORANGE));
        builder.add(EnumColour.getTriple(PINK, PURPLE, MAGENTA));
        builder.add(EnumColour.getTriple(WHITE, BLUE, LIGHT_BLUE));
        builder.add(EnumColour.getTriple(WHITE, GREEN, LIME));
        builder.add(EnumColour.getTriple(WHITE, RED, PINK));
        builder.add(EnumColour.getTriple(WHITE, BLACK, GRAY));
        builder.add(EnumColour.getTriple(WHITE, GRAY, LIGHT_GRAY));
        builder.add(EnumColour.getTriple(BLUE, GREEN, CYAN));
        builder.add(EnumColour.getTriple(BLUE, RED, PURPLE));
        builder.add(EnumColour.getTriple(ORANGE, RED, BROWN));
        builder.add(EnumColour.getTriple(YELLOW, BLUE, GREEN));
        mixMap = builder.build();
    }
}

