/*
 * Decompiled with CFR 0.152.
 */
package repack.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import repack.com.ibm.icu.impl.CharacterIteration;
import repack.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import repack.com.ibm.icu.impl.breakiter.LanguageBreakEngine;
import repack.com.ibm.icu.lang.UCharacter;
import repack.com.ibm.icu.text.UnicodeSet;

public final class UnhandledBreakEngine
implements LanguageBreakEngine {
    volatile UnicodeSet fHandled = new UnicodeSet();

    @Override
    public boolean handles(int c) {
        return this.fHandled.contains(c);
    }

    @Override
    public int findBreaks(CharacterIterator text, int startPos, int endPos, DictionaryBreakEngine.DequeI foundBreaks, boolean isPhraseBreaking) {
        UnicodeSet uniset = this.fHandled;
        int c = CharacterIteration.current32(text);
        while (text.getIndex() < endPos && uniset.contains(c)) {
            CharacterIteration.next32(text);
            c = CharacterIteration.current32(text);
        }
        return 0;
    }

    public void handleChar(int c) {
        UnicodeSet originalSet = this.fHandled;
        if (!originalSet.contains(c)) {
            int script = UCharacter.getIntPropertyValue(c, 4106);
            UnicodeSet newSet = new UnicodeSet();
            newSet.applyIntPropertyValue(4106, script);
            newSet.addAll(originalSet);
            this.fHandled = newSet;
        }
    }
}

