/*
 * Decompiled with CFR 0.152.
 */
package gkappa.wrapfix.mixin;

import betterquesting.api.utils.RenderUtils;
import gkappa.wrapfix.WrapFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderUtils.class})
public abstract class MixinRenderUtils {
    @Shadow(remap=false)
    public static List<String> splitString(String str, int wrapWidth, FontRenderer font) {
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"splitString"}, cancellable=true, remap=false)
    private static void splitString(String str, int wrapWidth, FontRenderer font, CallbackInfoReturnable<List<String>> callback) {
        if (str.isEmpty()) {
            callback.setReturnValue(Collections.singletonList(""));
            return;
        }
        WrapFix.BREAK_ITERATOR.setText(str);
        ArrayList<String> list = new ArrayList<String>();
        int lineWidth = 0;
        int fed = 0;
        int prevFormat = 0;
        StringBuilder format = new StringBuilder();
        int[] widths = new int[str.length()];
        String[] formats = new String[str.length()];
        StringBuilder line = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean bold = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            char current = chars[i];
            switch (current) {
                case '\n': {
                    list.add(line.toString());
                    fed = i + 1;
                    line.delete(0, line.length()).append((CharSequence)format);
                    widths[0] = lineWidth = 0;
                    formats[0] = format.toString();
                    continue block4;
                }
                case '\u00a7': {
                    char f;
                    boolean isC;
                    if (i + 1 < chars.length && ((isC = MixinRenderUtils.isFormatColor(f = chars[i + 1])) || MixinRenderUtils.isFormatSpecial(f))) {
                        if (f != 'l' && f != 'L') {
                            if (f == 'r' || f == 'R') {
                                bold = false;
                                format.delete(0, format.length());
                            } else if (isC) {
                                bold = false;
                            }
                        } else {
                            bold = true;
                        }
                        format.append('\u00a7').append(f);
                        line.append('\u00a7').append(f);
                        widths[i - fed] = lineWidth;
                        widths[i - fed + 1] = lineWidth;
                        formats[i - fed] = format.toString();
                        formats[i - fed + 1] = format.toString();
                        ++i;
                        continue block4;
                    }
                }
                default: {
                    line.append(current);
                    lineWidth += font.func_78263_a(current);
                    if (bold) {
                        // empty if block
                    }
                    widths[i - fed] = ++lineWidth;
                    formats[i - fed] = format.toString();
                    if (lineWidth < wrapWidth) continue block4;
                    int icui = WrapFix.BREAK_ITERATOR.isBoundary(i) ? i : WrapFix.BREAK_ITERATOR.preceding(i);
                    if (icui <= fed + 1 || i == icui) {
                        list.add(line.substring(0, line.length() - 1));
                        fed = i;
                        line.delete(0, line.length()).append((CharSequence)format).append(current);
                        prevFormat = format.length();
                        lineWidth = font.func_78263_a(current);
                        continue block4;
                    }
                    int d = icui - fed;
                    if (line.charAt(d + prevFormat - 1) == '\u00a7') {
                        ++d;
                    }
                    list.add(line.substring(0, d + prevFormat));
                    String temp = line.substring(d + prevFormat);
                    fed += d;
                    line.delete(0, line.length()).append(formats[d]).append(temp);
                    prevFormat = formats[d].length();
                    lineWidth -= widths[d - 1];
                }
            }
        }
        list.add(line.toString());
        callback.setReturnValue(list);
    }

    @Inject(at={@At(value="HEAD")}, method={"splitStringWithoutFormat"}, cancellable=true, remap=false)
    private static void splitStringWithoutFormat(String str, int wrapWidth, FontRenderer font, CallbackInfoReturnable<List<String>> callback) {
        callback.setReturnValue(MixinRenderUtils.splitString(str, wrapWidth, font));
    }

    @Shadow(remap=false)
    private static boolean isFormatColor(char c1) {
        WrapFix.logger.error("MIXIN Failed");
        return false;
    }

    @Unique
    private static boolean isFormatSpecial(char formatChar) {
        return formatChar >= 'k' && formatChar <= 'o' || formatChar >= 'K' && formatChar <= 'O' || formatChar == 'r' || formatChar == 'R';
    }
}

