/*
 * Decompiled with CFR 0.152.
 */
package gkappa.wrapfix.mixin;

import com.google.common.collect.Lists;
import gkappa.wrapfix.WrapFix;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GuiUtilRenderComponents.class})
public class MixinGuiUtilRenderComponents {
    @Inject(at={@At(value="HEAD")}, method={"splitText"}, cancellable=true)
    private static void modifySplitText(ITextComponent textComponent, int maxWidth, FontRenderer fontRenderer, boolean notPreserveSpace, boolean forceTextColor, CallbackInfoReturnable<List<ITextComponent>> cir) {
        boolean wrapped;
        int j;
        int accumlateWidth = 0;
        ArrayList list = Lists.newArrayList();
        ArrayList cache = Lists.newArrayList();
        ArrayList styleCache = Lists.newArrayList();
        ArrayList newLineCache = Lists.newArrayList();
        ArrayList originList = Lists.newArrayList((Iterable)textComponent);
        for (j = 0; j < originList.size(); ++j) {
            ITextComponent originLine = (ITextComponent)originList.get(j);
            String unformattedOriginLine = originLine.func_150261_e();
            if (unformattedOriginLine.contains("\n")) {
                int k = unformattedOriginLine.indexOf(10);
                String stringAfter = unformattedOriginLine.substring(k + 1);
                unformattedOriginLine = unformattedOriginLine.substring(0, k + 1);
                TextComponentString textAfterN = new TextComponentString(stringAfter);
                textAfterN.func_150255_a(originLine.func_150256_b().func_150232_l());
                originList.add(j + 1, textAfterN);
                wrapped = true;
            } else {
                wrapped = false;
            }
            String rebuiltOriginLine = GuiUtilRenderComponents.func_178909_a((String)(originLine.func_150256_b().func_150218_j() + unformattedOriginLine), (boolean)forceTextColor);
            String cleanedLine = rebuiltOriginLine.endsWith("\n") ? rebuiltOriginLine.substring(0, rebuiltOriginLine.length() - 1) : rebuiltOriginLine;
            cache.add(cleanedLine);
            styleCache.add(originLine.func_150256_b());
            newLineCache.add(wrapped);
        }
        WrapFix.BREAK_ITERATOR.setText(String.join((CharSequence)"\n", cache));
        int fed = 0;
        TextComponentString lineToAdd = new TextComponentString("");
        for (j = 0; j < cache.size(); ++j) {
            String cleanedLine = (String)cache.get(j);
            Style style = (Style)styleCache.get(j);
            wrapped = (Boolean)newLineCache.get(j);
            int lineWidth = fontRenderer.func_78256_a(cleanedLine);
            TextComponentString line = new TextComponentString(cleanedLine);
            line.func_150255_a(style.func_150232_l());
            if (accumlateWidth + lineWidth > maxWidth) {
                String secondHalf;
                String firstHalf = fontRenderer.func_78262_a(cleanedLine, maxWidth - accumlateWidth, false);
                String string = secondHalf = firstHalf.length() < cleanedLine.length() ? cleanedLine.substring(firstHalf.length()) : null;
                if (secondHalf != null) {
                    int l = WrapFix.BREAK_ITERATOR.preceding(fed + firstHalf.length()) - fed;
                    if (l >= 0 && fontRenderer.func_78256_a(cleanedLine.substring(0, l)) > 0) {
                        firstHalf = cleanedLine.substring(0, l);
                        if (notPreserveSpace && cleanedLine.charAt(l) == ' ') {
                            ++l;
                        }
                        secondHalf = cleanedLine.substring(l);
                    } else if (accumlateWidth > 0 && !cleanedLine.contains(" ")) {
                        firstHalf = "";
                        secondHalf = cleanedLine;
                    }
                    secondHalf = FontRenderer.func_78282_e((String)firstHalf) + secondHalf;
                    cache.set(j, secondHalf);
                    --j;
                }
                lineWidth = fontRenderer.func_78256_a(firstHalf);
                line = new TextComponentString(firstHalf);
                line.func_150255_a(style.func_150232_l());
                wrapped = true;
            }
            if (accumlateWidth + lineWidth <= maxWidth) {
                accumlateWidth += lineWidth;
                lineToAdd.func_150257_a((ITextComponent)line);
                fed += line.func_150265_g().length();
            } else {
                wrapped = true;
                WrapFix.logger.debug("RARE CONDITION");
            }
            if (!wrapped) continue;
            list.add(lineToAdd);
            accumlateWidth = 0;
            lineToAdd = new TextComponentString("");
        }
        list.add(lineToAdd);
        cir.setReturnValue((Object)list);
    }
}

