/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.util.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiOpenEvent;

public class OpeningAnimation {
    private static GuiContainer lastGui;
    private static GuiContainer animatedGui;
    private static long startTime;
    private static boolean shouldCloseLast;

    public static boolean onGuiOpen(GuiOpenEvent event) {
        GuiScreen guiScreen = event.getGui();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            if (Minecraft.func_71410_x().field_71462_r == null) {
                OpeningAnimation.animate(container, true);
            }
        } else if (Minecraft.func_71410_x().field_71462_r == lastGui && event.getGui() == null && !shouldCloseLast) {
            OpeningAnimation.animate(lastGui, false);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static void animate(GuiContainer container, boolean open) {
        if (NEAConfig.openingAnimationTime == 0 || NEAConfig.isBlacklisted((GuiScreen)container)) {
            return;
        }
        animatedGui = container;
        lastGui = container;
        startTime = NEA.time() * (long)(open ? 1 : -1);
    }

    public static float getScale(GuiContainer container) {
        float min = 0.75f;
        float max = 1.0f;
        return Interpolations.lerp(min, max, OpeningAnimation.getValue(container));
    }

    public static float getValue(GuiContainer container) {
        if (shouldCloseLast) {
            return 0.001f;
        }
        if (animatedGui != container) {
            return 1.0f;
        }
        float val = (float)(NEA.time() - Math.abs(startTime)) / (float)NEAConfig.openingAnimationTime;
        if (startTime < 0L) {
            if ((val = 1.0f - val) <= 0.0f) {
                animatedGui = null;
                shouldCloseLast = true;
                return 0.0f;
            }
        } else if (val >= 1.0f) {
            animatedGui = null;
            return 1.0f;
        }
        return NEAConfig.openingAnimationCurve.interpolate(0.0f, 1.0f, val);
    }

    public static boolean handleScale(GuiContainer container, boolean translateToPanel) {
        float scale = OpeningAnimation.getScale(container);
        if (scale == 1.0f || NEAConfig.moveAnimationTime == 0) {
            return false;
        }
        if (translateToPanel) {
            GlStateManager.func_179109_b((float)container.getGuiLeft(), (float)container.getGuiTop(), (float)0.0f);
        }
        GlStateManager.func_179109_b((float)((float)container.getXSize() / 2.0f), (float)((float)container.getYSize() / 2.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)(-container.getXSize()) / 2.0f), (float)((float)(-container.getYSize()) / 2.0f), (float)0.0f);
        if (translateToPanel) {
            GlStateManager.func_179109_b((float)(-container.getGuiLeft()), (float)(-container.getGuiTop()), (float)0.0f);
        }
        return true;
    }

    public static void checkGuiToClose() {
        if (shouldCloseLast && lastGui != null) {
            Minecraft.func_71410_x().func_147108_a(null);
            shouldCloseLast = false;
            lastGui = null;
        }
    }

    static {
        startTime = 0L;
        shouldCloseLast = false;
    }
}

