/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations;

import com.cleanroommc.neverenoughanimations.IItemLocation;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemHoverAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMoveAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemPickupThrowAnimation;
import com.cleanroommc.neverenoughanimations.animations.OpeningAnimation;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="neverenoughanimations", version="1.0.5", name="NeverEnoughAnimations", acceptedMinecraftVersions="[1.12.2]", clientSideOnly=true, dependencies="required:mixinbooter@[8.8,);")
public class NEA {
    public static final Logger LOGGER = LogManager.getLogger((String)"neverenoughanimations");
    private static boolean itemBordersLoaded = false;
    private static boolean jeiLoaded = false;
    private static boolean heiLoaded = false;
    private static int mouseX;
    private static int mouseY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        itemBordersLoaded = Loader.isModLoaded((String)"itemborders");
        jeiLoaded = Loader.isModLoaded((String)"jei");
        if (jeiLoaded) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("jei");
            heiLoaded = "Had Enough Items".equals(mod.getName());
        }
    }

    @SubscribeEvent
    public void onGuiTick(TickEvent.ClientTickEvent event) {
        OpeningAnimation.checkGuiToClose();
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ItemHoverAnimation.onGuiTick();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("neverenoughanimations")) {
            NEAConfig.blacklistCache.clear();
            ConfigManager.sync((String)"neverenoughanimations", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (OpeningAnimation.onGuiOpen(event)) {
            return;
        }
        ItemHoverAnimation.onGuiOpen(event);
        ItemMoveAnimation.onGuiOpen(event);
        ItemPickupThrowAnimation.onGuiOpen(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGuiDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        mouseX = event.getMouseX();
        mouseY = event.getMouseY();
        if (NEAConfig.moveAnimationTime > 0 && event.getGui() instanceof GuiContainer) {
            GlStateManager.func_179094_E();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen guiScreen;
        if (NEAConfig.moveAnimationTime > 0 && (guiScreen = event.getGui()) instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            GlStateManager.func_179121_F();
            OpeningAnimation.getScale(container);
        }
    }

    @SubscribeEvent
    public void drawDebugInfo(GuiScreenEvent.BackgroundDrawnEvent event) {
        GuiScreen guiScreen = event.getGui();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            NEA.drawScreenDebug(container, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiBackgroundDrawn(GuiScreenEvent.BackgroundDrawnEvent event) {
        GuiScreen guiScreen;
        if (NEAConfig.moveAnimationTime > 0 && (guiScreen = event.getGui()) instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            OpeningAnimation.handleScale(container, true);
        }
    }

    public static int getMouseX() {
        return mouseX;
    }

    public static int getMouseY() {
        return mouseY;
    }

    public static void drawScreenDebug(GuiContainer container, int mouseX, int mouseY) {
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment() || container.getClass().getName().contains("modularui")) {
            return;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        int screenH = container.field_146295_m;
        int color = new Color(180, 40, 115).getRGB();
        int lineY = screenH - 13;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        container.func_73731_b(fr, "Mouse Pos: " + mouseX + ", " + mouseY, 5, lineY, color);
        container.func_73731_b(fr, "Rel. Mouse Pos: " + (mouseX - container.getGuiLeft()) + ", " + (mouseY - container.getGuiTop()), 5, lineY -= 11, color);
        IItemLocation slot = IItemLocation.of(container.getSlotUnderMouse());
        if (slot != null) {
            container.func_73731_b(fr, "Pos: " + slot.nea$getX() + ", " + slot.nea$getY(), 5, lineY -= 11, color);
            container.func_73731_b(fr, "Class: " + slot.getClass().getSimpleName(), 5, lineY -= 11, color);
            container.func_73731_b(fr, "Slot Number: " + slot.nea$getSlotNumber(), 5, lineY -= 11, color);
            lineY -= 11;
        }
        Gui.func_73734_a((int)mouseX, (int)mouseY, (int)(mouseX + 1), (int)(mouseY + 1), (int)new Color(10, 230, 10, 124).getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
    }

    public static boolean isItemBordersLoaded() {
        return itemBordersLoaded;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded;
    }

    public static boolean isHeiLoaded() {
        return heiLoaded;
    }

    public static long time() {
        return System.nanoTime() / 1000000L;
    }
}

