/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.ContextMenu;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public class ContextMenuItem
implements Comparable<ContextMenuItem> {
    public static final ContextMenuItem SEPARATOR = new ContextMenuItem("", Icon.EMPTY, () -> {}){

        @Override
        public Widget createWidget(ContextMenu panel) {
            return new ContextMenu.CSeperator(panel);
        }
    };
    public static final BooleanSupplier TRUE = () -> true;
    public static final BooleanSupplier FALSE = () -> false;
    public String title;
    public Icon icon;
    public Runnable callback;
    public BooleanSupplier enabled = TRUE;
    public String yesNoText = "";
    public boolean closeMenu = true;

    public ContextMenuItem(String t, Icon i, @Nullable Runnable c) {
        this.title = t;
        this.icon = i;
        this.callback = c;
    }

    public void addMouseOverText(List<String> list) {
    }

    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        this.icon.draw(x, y, w, h);
    }

    public ContextMenuItem setEnabled(boolean v) {
        return this.setEnabled(v ? TRUE : FALSE);
    }

    public ContextMenuItem setEnabled(BooleanSupplier v) {
        this.enabled = v;
        return this;
    }

    public ContextMenuItem setYesNo(String s) {
        this.yesNoText = s;
        return this;
    }

    public ContextMenuItem setCloseMenu(boolean v) {
        this.closeMenu = v;
        return this;
    }

    public Widget createWidget(ContextMenu panel) {
        return new ContextMenu.CButton(panel, this);
    }

    @Override
    public int compareTo(ContextMenuItem o) {
        return StringUtils.unformatted(this.title).compareToIgnoreCase(StringUtils.unformatted(o.title));
    }

    public void onClicked(Panel panel, MouseButton button) {
        if (this.closeMenu) {
            panel.getGui().closeContextMenu();
        }
        this.callback.run();
    }
}

