/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigSavedEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerDataEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.NBTDataStorage;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.EnumPrivacyLevel;
import com.feed_the_beast.ftblib.net.MessageSyncData;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import net.minecraftforge.server.permission.context.WorldContext;

public class ForgePlayer
implements INBTSerializable<NBTTagCompound>,
Comparable<ForgePlayer>,
IConfigCallback {
    private static FakePlayer playerForStats;
    public GameProfile profile;
    private final NBTDataStorage dataStorage;
    public ForgeTeam team;
    private boolean hideTeamNotification;
    public NBTTagCompound cachedPlayerNBT;
    private ConfigGroup cachedConfig;
    public long lastTimeSeen;
    public boolean needsSaving;
    public EntityPlayerMP tempPlayer;

    public ForgePlayer(Universe u, GameProfile p) {
        this.profile = p;
        this.dataStorage = new NBTDataStorage();
        this.team = u.getTeam("");
        this.hideTeamNotification = false;
        new ForgePlayerDataEvent(this, this.dataStorage).post();
        this.needsSaving = false;
    }

    public ForgePlayer(Universe u, UUID id, String name) {
        this(u, new GameProfile(id, name));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("HideTeamNotification", this.hideTeamNotification);
        nbt.func_74772_a("LastTimeSeen", this.lastTimeSeen);
        nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.hideTeamNotification = nbt.func_74767_n("HideTeamNotification");
        this.lastTimeSeen = nbt.func_74763_f("LastTimeSeen");
        this.dataStorage.deserializeNBT(nbt.func_74775_l("Data"));
    }

    public void clearCache() {
        this.cachedPlayerNBT = null;
        this.cachedConfig = null;
        this.dataStorage.clearCache();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.team.universe.checkSaving = true;
    }

    public boolean hasTeam() {
        return this.team.isValid();
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public final UUID getId() {
        return this.profile.getId();
    }

    public final String getName() {
        return this.profile.getName();
    }

    public final String getDisplayNameString() {
        if (this.isOnline()) {
            try {
                return this.getPlayer().getDisplayNameString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getName();
    }

    public final ITextComponent getDisplayName() {
        if (this.isOnline()) {
            try {
                return this.getPlayer().func_145748_c_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TextComponentString(this.getName());
    }

    public EntityPlayerMP getCommandPlayer(ICommandSender sender) throws CommandException {
        if (!this.isOnline()) {
            throw FTBLib.error(sender, "player_must_be_online", new Object[0]);
        }
        return this.getPlayer();
    }

    public NBTDataStorage getData() {
        return this.dataStorage;
    }

    public boolean equalsPlayer(@Nullable ForgePlayer player) {
        return player == this || player != null && this.getId().equals(player.getId());
    }

    public boolean equalsPlayer(@Nullable ICommandSender player) {
        return player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_110124_au().equals(this.getId());
    }

    @Override
    public final int compareTo(ForgePlayer o) {
        return StringUtils.IGNORE_CASE_COMPARATOR.compare(this.getDisplayNameString(), o.getDisplayNameString());
    }

    public final String toString() {
        return this.getName();
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ForgePlayer && this.equalsPlayer((ForgePlayer)o);
    }

    public boolean canInteract(@Nullable ForgePlayer owner, EnumPrivacyLevel level) {
        if (level == EnumPrivacyLevel.PUBLIC || owner == null) {
            return true;
        }
        if (owner.equalsPlayer(this)) {
            return true;
        }
        if (level == EnumPrivacyLevel.PRIVATE) {
            return false;
        }
        if (level == EnumPrivacyLevel.TEAM) {
            return owner.team.isAlly(this);
        }
        return false;
    }

    public boolean isOnline() {
        return this.getNullablePlayer() != null;
    }

    @Nullable
    public EntityPlayerMP getNullablePlayer() {
        if (this.tempPlayer != null) {
            return this.tempPlayer;
        }
        return this.team.universe.server.func_184103_al().func_177451_a(this.getId());
    }

    public EntityPlayerMP getPlayer() {
        EntityPlayerMP p = this.getNullablePlayer();
        if (p == null) {
            throw new NullPointerException(this.getName() + " is not online!");
        }
        return p;
    }

    public boolean isFake() {
        return this.tempPlayer instanceof FakePlayer;
    }

    public boolean isOP() {
        return ServerUtils.isOP(this.team.universe.server, this.getProfile());
    }

    void onLoggedIn(EntityPlayerMP player, Universe universe, boolean firstLogin) {
        this.tempPlayer = player;
        boolean sendTeamJoinEvent = false;
        boolean sendTeamCreatedEvent = false;
        if (firstLogin && (FTBLibConfig.teams.disable_teams || (player.field_71133_b.func_71264_H() ? FTBLibConfig.teams.autocreate_sp : FTBLibConfig.teams.autocreate_mp))) {
            if (player.field_71133_b.func_71264_H()) {
                this.team = universe.getTeam("singleplayer");
                if (!this.team.isValid()) {
                    this.team = new ForgeTeam(universe, 2, "singleplayer", TeamType.SERVER);
                    this.team.setFreeToJoin(true);
                    universe.addTeam(this.team);
                    this.team.setTitle(this.getName());
                    this.team.setIcon(new PlayerHeadIcon(this.getId()).toString());
                    this.team.setColor(EnumTeamColor.NAME_MAP.getRandom(universe.world.field_73012_v));
                    this.team.markDirty();
                    sendTeamCreatedEvent = true;
                }
                sendTeamJoinEvent = true;
            } else {
                String id = this.getName().toLowerCase();
                if (universe.getTeam(id).isValid()) {
                    id = StringUtils.fromUUID(this.getId());
                }
                if (!universe.getTeam(id).isValid()) {
                    this.team = new ForgeTeam(universe, universe.generateTeamUID(0), id, TeamType.PLAYER);
                    this.team.owner = this;
                    universe.addTeam(this.team);
                    this.team.setColor(EnumTeamColor.NAME_MAP.getRandom(universe.world.field_73012_v));
                    this.team.markDirty();
                    sendTeamCreatedEvent = true;
                    sendTeamJoinEvent = true;
                }
            }
        }
        if (!this.isFake()) {
            this.lastTimeSeen = universe.ticks.ticks();
            new MessageSyncData(true, player, this).sendTo(player);
        }
        new ForgePlayerLoggedInEvent(this).post();
        if (sendTeamCreatedEvent) {
            new ForgeTeamCreatedEvent(this.team).post();
        }
        if (sendTeamJoinEvent) {
            ForgeTeamPlayerJoinedEvent event = new ForgeTeamPlayerJoinedEvent(this);
            event.post();
            if (event.getDisplayGui() != null) {
                event.getDisplayGui().run();
            }
        }
        if (!this.hideTeamNotification() && !this.hasTeam()) {
            ITextComponent b1 = FTBLib.lang((ICommandSender)player, "click_here", new Object[0]);
            b1.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftblib_simulate_button custom:ftblib:my_team_gui"));
            b1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLib.lang((ICommandSender)player, "sidebar_button.ftblib.my_team", new Object[0])));
            ITextComponent b2 = FTBLib.lang((ICommandSender)player, "click_here", new Object[0]);
            b2.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/my_settings ftblib.hide_team_notification toggle"));
            b2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLib.lang((ICommandSender)player, "ftblib.lang.team.notification.hide", new Object[0])));
            player.func_145747_a(FTBLib.lang((ICommandSender)player, "ftblib.lang.team.notification", b1, b2));
        }
        universe.clearCache();
        this.tempPlayer = null;
        this.markDirty();
    }

    void onLoggedOut(EntityPlayerMP p) {
        this.tempPlayer = p;
        this.lastTimeSeen = p.field_70170_p.func_82737_E();
        new ForgePlayerLoggedOutEvent(this).post();
        this.clearCache();
        this.tempPlayer = null;
        this.markDirty();
    }

    public StatisticsManagerServer stats() {
        if (playerForStats == null) {
            playerForStats = new FakePlayer(this.team.universe.world, ServerUtils.FAKE_PLAYER_PROFILE);
        }
        playerForStats.func_70029_a((World)this.team.universe.world);
        playerForStats.func_184221_a(this.getId());
        return this.team.universe.server.func_184103_al().func_152602_a((EntityPlayer)playerForStats);
    }

    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = ConfigGroup.newGroup("player_config");
            this.cachedConfig.setDisplayName((ITextComponent)new TextComponentTranslation("player_config", new Object[0]));
            ForgePlayerConfigEvent event = new ForgePlayerConfigEvent(this, this.cachedConfig);
            event.post();
            ConfigGroup config = this.cachedConfig.getGroup("ftblib");
            config.setDisplayName((ITextComponent)new TextComponentString("FTB Library"));
            config.addBool("hide_team_notification", () -> this.hideTeamNotification, v -> {
                this.hideTeamNotification = v;
            }, false);
        }
        return this.cachedConfig;
    }

    public NBTTagCompound getPlayerNBT() {
        if (this.isOnline()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.getPlayer().func_189511_e(nbt);
            return nbt;
        }
        if (this.cachedPlayerNBT == null) {
            try (FileInputStream stream = new FileInputStream(new File(this.team.universe.getWorldDirectory(), "playerdata/" + this.getId() + ".dat"));){
                this.cachedPlayerNBT = CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.cachedPlayerNBT == null) {
            this.cachedPlayerNBT = new NBTTagCompound();
        }
        return this.cachedPlayerNBT;
    }

    public void setPlayerNBT(NBTTagCompound nbt) {
        if (this.isOnline()) {
            EntityPlayerMP player = this.getPlayer();
            player.deserializeNBT(nbt);
            if (player.func_70089_S()) {
                player.field_70170_p.func_72866_a((Entity)player, true);
            }
        } else {
            try (FileOutputStream stream = new FileOutputStream(new File(this.team.universe.getWorldDirectory(), "playerdata/" + this.getId() + ".dat"));){
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.markDirty();
    }

    public boolean hideTeamNotification() {
        return FTBLibConfig.teams.hide_team_notification || this.hideTeamNotification || this.isFake();
    }

    public long getLastTimeSeen() {
        return this.isOnline() ? this.team.universe.ticks.ticks() : this.lastTimeSeen;
    }

    public boolean hasPermission(String node, @Nullable IContext context) {
        return PermissionAPI.hasPermission((GameProfile)this.getProfile(), (String)node, (IContext)context);
    }

    public IContext getContext() {
        if (this.isOnline()) {
            return new PlayerContext((EntityPlayer)this.getPlayer());
        }
        return new WorldContext((World)this.team.universe.world);
    }

    public boolean hasPermission(String node) {
        return PermissionAPI.hasPermission((GameProfile)this.getProfile(), (String)node, (IContext)this.getContext());
    }

    public ConfigValue getRankConfig(String node) {
        return RankConfigAPI.get(this.team.universe.server, this.getProfile(), node);
    }

    public File getDataFile(String ext) {
        File oldExtFile;
        File extFile;
        File dir = new File(this.team.universe.getWorldDirectory(), "data/ftb_lib/players/");
        if (ext.isEmpty()) {
            return new File(dir, this.getName().toLowerCase() + ".dat");
        }
        File extFolder = new File(dir, ext);
        if (!extFolder.exists()) {
            extFolder.mkdirs();
        }
        if (!(extFile = new File(extFolder, this.getName().toLowerCase() + ".dat")).exists() && (oldExtFile = new File(dir, this.getName().toLowerCase() + "." + ext + ".dat")).exists()) {
            oldExtFile.renameTo(extFile);
        }
        return extFile;
    }

    @Override
    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.clearCache();
        this.markDirty();
        new ForgePlayerConfigSavedEvent(this, group, sender).post();
    }
}

