/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;

public class ConfigTeam
extends ConfigValue {
    public static final String TEAM_ID = "team";
    private final Supplier<ForgeTeam> get;
    private final Consumer<ForgeTeam> set;

    public ConfigTeam(Supplier<ForgeTeam> g, Consumer<ForgeTeam> s) {
        this.get = g;
        this.set = s;
    }

    @Override
    public String getId() {
        return TEAM_ID;
    }

    @Override
    public ITextComponent getStringForGUI() {
        return this.get.get().getTitle();
    }

    @Override
    public String getString() {
        return this.get.get().getId();
    }

    @Override
    public boolean getBoolean() {
        return this.get.get().isValid();
    }

    @Override
    public int getInt() {
        return this.get.get().getUID();
    }

    @Override
    public ConfigTeam copy() {
        throw new IllegalStateException("Not supported!");
    }

    @Override
    public Color4I getColor() {
        return this.get.get().getColor().getColor();
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> list = new ArrayList<String>();
        for (ForgeTeam team : this.get.get().universe.getTeams()) {
            list.add(team.getId());
        }
        list.sort(null);
        return list;
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74768_a(key, this.getInt());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        NBTBase id = nbt.func_74781_a(key);
        if (id instanceof NBTTagString) {
            this.set.accept(this.get.get().universe.getTeam(((NBTTagString)id).func_150285_a_()));
        } else if (id instanceof NBTPrimitive) {
            this.set.accept(this.get.get().universe.getTeam(((NBTPrimitive)id).func_150287_d()));
        }
    }

    @Override
    public void writeData(DataOut data) {
        ForgeTeam team = this.get.get();
        Collection<ForgeTeam> teams = team.universe.getTeams();
        data.writeVarInt(teams.size());
        for (ForgeTeam t : teams) {
            data.writeInt(t.getUID());
            data.writeString(t.getId());
            data.writeTextComponent(t.getTitle());
            data.writeIcon(t.getIcon());
        }
        data.writeString(this.getString());
    }

    @Override
    public void readData(DataIn data) {
        throw new IllegalStateException("Can't read Team property!");
    }
}

