/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.command.team;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibGameRules;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.net.MessageMyTeamGuiResponse;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CmdCreate
extends CmdBase {
    public CmdCreate() {
        super("create", CmdBase.Level.ALL);
    }

    public static boolean isValidTeamID(String s) {
        if (!s.isEmpty()) {
            for (int i = 0; i < s.length(); ++i) {
                if (CmdCreate.isValidChar(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValidChar(char c) {
        return c == '_' || c == '|' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!FTBLibGameRules.canCreateTeam((World)server.func_71218_a(0))) {
            throw FTBLib.error(sender, "feature_disabled_server", new Object[0]);
        }
        EntityPlayerMP player = CmdCreate.func_71521_c((ICommandSender)sender);
        ForgePlayer p = CommandUtils.getForgePlayer((ICommandSender)player);
        if (p.hasTeam()) {
            throw FTBLib.error(sender, "ftblib.lang.team.error.must_leave", new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        if (!CmdCreate.isValidTeamID(args[0])) {
            throw FTBLib.error(sender, "ftblib.lang.team.id_invalid", new Object[0]);
        }
        if (p.team.universe.getTeam(args[0]).isValid()) {
            throw FTBLib.error(sender, "ftblib.lang.team.id_already_exists", new Object[0]);
        }
        p.team.universe.clearCache();
        ForgeTeam team = new ForgeTeam(p.team.universe, p.team.universe.generateTeamUID(0), args[0], TeamType.PLAYER);
        if (args.length > 1) {
            team.setColor(EnumTeamColor.NAME_MAP.get(args[1]));
        } else {
            team.setColor(EnumTeamColor.NAME_MAP.getRandom(sender.func_130014_f_().field_73012_v));
        }
        p.team = team;
        team.owner = p;
        team.universe.addTeam(team);
        new ForgeTeamCreatedEvent(team).post();
        ForgeTeamPlayerJoinedEvent event = new ForgeTeamPlayerJoinedEvent(p);
        event.post();
        sender.func_145747_a(FTBLib.lang(sender, "ftblib.lang.team.created", team.getId()));
        if (event.getDisplayGui() != null) {
            event.getDisplayGui().run();
        } else {
            new MessageMyTeamGuiResponse(p).sendTo(player);
        }
        team.markDirty();
        p.markDirty();
    }
}

