/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.client.ClientConfig;
import com.feed_the_beast.ftblib.client.FTBLibClient;
import com.feed_the_beast.ftblib.client.FTBLibResourceType;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.google.gson.JsonElement;
import java.io.FileNotFoundException;
import java.util.function.Predicate;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;

public enum FTBLibClientConfigManager implements ISelectiveResourceReloadListener
{
    INSTANCE;


    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> resourcePredicate) {
        if (!resourcePredicate.test(FTBLibResourceType.FTB_CONFIG)) {
            return;
        }
        FTBLibClient.CLIENT_CONFIG_MAP.clear();
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "client_config.json"))) {
                    for (JsonElement e : DataReader.get(resource).json().getAsJsonArray()) {
                        ClientConfig c = new ClientConfig(e.getAsJsonObject());
                        FTBLibClient.CLIENT_CONFIG_MAP.put(c.id, c);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
    }
}

