/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.mixin.minecraft.forge;

import github.kasuminova.novaeng.NovaEngineeringCore;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SimpleNetworkWrapper.class})
public class MixinSimpleNetworkWrapper {
    @Shadow(remap=false)
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    @Inject(method={"sendToAll"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendToAll(IMessage message, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }

    @Inject(method={"sendTo"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendTo(IMessage message, EntityPlayerMP player, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllAround"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendToAllAround(IMessage message, NetworkRegistry.TargetPoint point, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllTracking(Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendToAllTrackingPoint(IMessage message, NetworkRegistry.TargetPoint point, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_POINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllTracking(Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendToAllTracking(IMessage message, Entity entity, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_ENTITY);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entity);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }

    @Inject(method={"sendToDimension"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectSendToDimension(IMessage message, int dimensionId, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        if (NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.isBlacklistChannel(this)) {
            return;
        }
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(this, () -> {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        });
        ci.cancel();
    }
}

