/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.mixin.dme;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import github.kasuminova.novaeng.common.util.UTF8FileReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MetadataManager.class})
public class MixinMetadataManager {
    @Overwrite(remap=false)
    private static Optional<JsonArray> readConfigFile(File file) {
        JsonElement result;
        UTF8FileReader fileReader;
        String filename = file.getName();
        try {
            fileReader = new UTF8FileReader(file);
        }
        catch (FileNotFoundException var9) {
            FileNotFoundException e = var9;
            DMLRelearned.logger.error("Config file \"{}\" not found! Error message: {}", (Object)filename, (Object)e.getMessage());
            return Optional.empty();
        }
        try (JsonReader reader = new JsonReader((Reader)fileReader);){
            JsonParser parser = new JsonParser();
            reader.setLenient(true);
            result = parser.parse(reader);
        }
        catch (Exception var10) {
            Exception e = var10;
            if (e instanceof IOException) {
                DMLRelearned.logger.error("Error reading config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            } else if (e instanceof JsonSyntaxException) {
                DMLRelearned.logger.error("Invalid JSON in config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            } else {
                DMLRelearned.logger.error("Exception while reading config file \"{}\"! Error message: {}", (Object)filename, (Object)e.getMessage());
            }
            return Optional.empty();
        }
        if (!result.isJsonArray()) {
            DMLRelearned.logger.error("Error parsing config file \"{}\": root element must be an array!", (Object)filename);
            return Optional.empty();
        }
        return Optional.of(result.getAsJsonArray());
    }
}

