/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.mixin.cofh;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.mixin.cofh.AccessorPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketHandler.class})
public class MixinPacketHandler {
    @Inject(method={"sendToAll"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendToAll(PacketBase message, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendTo(Lcofh/core/network/PacketBase;Lnet/minecraft/entity/player/EntityPlayerMP;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendTo(PacketBase message, EntityPlayerMP player, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendTo(Lcofh/core/network/PacketBase;Lnet/minecraft/entity/player/EntityPlayer;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendTo(PacketBase message, EntityPlayer player, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllAround(Lcofh/core/network/PacketBase;Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendToAllTrackingPoint(PacketBase message, NetworkRegistry.TargetPoint point, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllAround(Lcofh/core/network/PacketBase;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendToAllTracking(PacketBase message, TileEntity theTile, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(theTile.func_145831_w().field_73011_w.getDimension(), (double)theTile.func_174877_v().func_177958_n(), (double)theTile.func_174877_v().func_177956_o(), (double)theTile.func_174877_v().func_177952_p(), 192.0));
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendToAllAround(Lcofh/core/network/PacketBase;Lnet/minecraft/world/World;III)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendToAllAround(PacketBase message, World world, int x, int y, int z, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)x, (double)y, (double)z, 192.0));
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }

    @Inject(method={"sendToDimension"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectSendToDimension(PacketBase message, int dimensionId, CallbackInfo ci) {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_152345_ab()) {
            return;
        }
        AccessorPacketHandler instance = (AccessorPacketHandler)PacketHandler.INSTANCE;
        NovaEngineeringCore.PARALLEL_NETWORK_MANAGER.offerAction(PacketHandler.INSTANCE, () -> {
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            instance.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            instance.getChannels().get(Side.SERVER).writeAndFlush((Object)message);
        });
        ci.cancel();
    }
}

