/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.mixin.astralsorcery;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.mixin.astralsorcery.AccessorResearchManager;
import github.kasuminova.novaeng.mixin.astralsorcery.InvokerPerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerProgress.class})
public abstract class MixinPlayerProgress {
    @Shadow(remap=false)
    public abstract Collection<AbstractPerk> getAppliedPerks();

    @Shadow(remap=false)
    public abstract List<AbstractPerk> getSealedPerks();

    @Inject(method={"load"}, at={@At(value="HEAD")}, remap=false)
    private void onLoadPre(NBTTagCompound compound, CallbackInfo ci) {
        EntityPlayerMP player = this.novaeng$getCurrentPlayer();
        if (player == null) {
            return;
        }
        NovaEngineeringCore.log.info("Try to removing all perk data for player " + player.func_146103_bH().getName() + ".");
        try {
            for (AbstractPerk perk : this.getAppliedPerks()) {
                ((InvokerPerkEffectHelper)PerkEffectHelper.EVENT_INSTANCE).invokeHandlePerkRemoval(perk, (EntityPlayer)player, Side.SERVER);
            }
            for (AbstractPerk perk : this.getSealedPerks()) {
                ((InvokerPerkEffectHelper)PerkEffectHelper.EVENT_INSTANCE).invokeHandlePerkRemoval(perk, (EntityPlayer)player, Side.SERVER);
            }
        }
        catch (Throwable e) {
            NovaEngineeringCore.log.warn("Remove failed!", e);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")}, remap=false)
    private void onLoadPost(NBTTagCompound compound, CallbackInfo ci) {
        EntityPlayerMP player = this.novaeng$getCurrentPlayer();
        if (player == null) {
            return;
        }
        NovaEngineeringCore.log.info("Try to restoring new perk data for player " + player.func_146103_bH().getName() + ".");
        try {
            ((InvokerPerkEffectHelper)PerkEffectHelper.EVENT_INSTANCE).invokeHandlePerkModification((EntityPlayer)player, Side.SERVER, false);
        }
        catch (Throwable e) {
            NovaEngineeringCore.log.warn("Restore failed!", e);
        }
    }

    @Unique
    @Nullable
    private EntityPlayerMP novaeng$getCurrentPlayer() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        Map<UUID, PlayerProgress> playerProgress = AccessorResearchManager.getPlayerProgressServer();
        UUID playerUUID = null;
        for (Map.Entry<UUID, PlayerProgress> entry : playerProgress.entrySet()) {
            if (entry.getValue() != this) continue;
            playerUUID = entry.getKey();
        }
        if (playerUUID == null) {
            return null;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerUUID);
    }
}

