/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.mixin;

import github.kasuminova.novaeng.common.mod.Mods;
import github.kasuminova.novaeng.mixin.NovaEngCoreEarlyMixinLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import zone.rong.mixinbooter.ILateMixinLoader;

public class NovaEngCoreLateMixinLoader
implements ILateMixinLoader {
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            NovaEngCoreEarlyMixinLoader.LOG.warn("[NOVAENG_CORE_PRE] Mixin config {} is not found in config map! It will never be loaded.", (Object)mixinConfig);
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static boolean modLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID) {
        MIXIN_CONFIGS.put(mixinConfig, () -> NovaEngCoreLateMixinLoader.modLoaded(modID));
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, String ... modIDs) {
        MIXIN_CONFIGS.put(mixinConfig, () -> NovaEngCoreLateMixinLoader.modLoaded(modID) && Arrays.stream(modIDs).allMatch(Loader::isModLoaded));
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        NovaEngCoreLateMixinLoader.addMixinCFG("mixins.novaeng_core.json");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_ae2.json", "appliedenergistics2");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_astralsorcery.json", "astralsorcery");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_athenaeum.json", "athenaeum");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_cofhcore.json", "cofhcore");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_draconicevolution.json", "draconicevolution");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_ic2.json", "ic2");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_immersiveengineering.json", "immersiveengineering");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_mets.json", "mets");
        NovaEngCoreLateMixinLoader.addModdedMixinCFG("mixins.novaeng_core_nae2.json", "nae2");
        NovaEngCoreLateMixinLoader.addMixinCFG("mixins.novaeng_core_forge_late.json");
        NovaEngCoreLateMixinLoader.addMixinCFG("mixins.novaeng_core_unidict.json", () -> Mods.UNIDICT.loaded() && Mods.MEKCEU.loaded());
        NovaEngCoreLateMixinLoader.addMixinCFG("mixins.novaeng_core_dme.json", () -> Loader.isModLoaded((String)"deepmoblearning") && ((ModContainer)Loader.instance().getIndexedModList().get("deepmoblearning")).getName().equals("DeepMobEvolution"));
    }
}

