/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class WorldPos {
    private final World world;
    private final BlockPos pos;
    private final int hash;

    public WorldPos(World world, BlockPos pos, int hash) {
        this.world = world;
        this.pos = pos;
        this.hash = hash;
    }

    public static WorldPos of(World world, BlockPos pos) {
        return new WorldPos(world, pos, Objects.hash(world, pos));
    }

    public static WorldPos of(TileEntity te) {
        return WorldPos.of(te.func_145831_w(), te.func_174877_v());
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorldPos) {
            WorldPos other = (WorldPos)obj;
            return this.world == other.world && this.pos.equals((Object)other.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "WorldPos[" + "world=" + this.world + "," + "pos=" + this.pos + "," + "hash=" + this.hash + "]";
    }

    public World world() {
        return this.world;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public int hash() {
        return this.hash;
    }
}

