/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.IItemHandlerImpl;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileItemHandler
extends IItemHandlerImpl {
    protected final String invName;
    protected final BitSet availableSlots = new BitSet();
    protected final TileEntitySynchronized owner;
    private IntConsumer onChangedListener = null;

    public static TileItemHandler create(TileEntitySynchronized owner, int slotCount, String invName) {
        int[] slotIDs = new int[slotCount];
        for (int slotID = 0; slotID < slotIDs.length; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        return new TileItemHandler(owner, slotIDs, slotIDs, invName).setAllSlotAvailable().updateSlotLimits();
    }

    public TileItemHandler(TileEntitySynchronized owner, int[] inSlots, int[] outSlots, String invName) {
        super(inSlots, outSlots);
        this.owner = owner;
        this.invName = invName;
    }

    public TileItemHandler updateInOutSlots() {
        int[] slotIDs = new int[this.inventory.length];
        for (int slotID = 0; slotID < slotIDs.length; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        this.inSlots = slotIDs;
        this.outSlots = slotIDs;
        return this;
    }

    public TileItemHandler updateSlotLimits() {
        int[] slotLimits = new int[this.inventory.length];
        Arrays.fill(slotLimits, 1);
        this.slotLimits = slotLimits;
        return this;
    }

    public TileItemHandler setOnChangedListener(IntConsumer onChangedListener) {
        this.onChangedListener = onChangedListener;
        return this;
    }

    public boolean isSlotAvailable(int slotID) {
        return this.availableSlots.get(slotID);
    }

    public TileItemHandler setSlotAvailable(int slotID) {
        this.availableSlots.set(slotID);
        return this;
    }

    public TileItemHandler setAllSlotAvailable() {
        this.availableSlots.set(0, this.inventory.length);
        return this;
    }

    public TileItemHandler setUnavailableSlots(int[] slotIDs) {
        for (int slotID : slotIDs) {
            this.availableSlots.set(slotID, false);
        }
        return this;
    }

    public TileItemHandler setUnavailableSlot(int slotID) {
        this.availableSlots.set(slotID, false);
        return this;
    }

    public IntStream getAvailableSlotsStream() {
        return this.availableSlots.stream();
    }

    public String getInvName() {
        return this.invName;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if (this.onChangedListener != null) {
            this.onChangedListener.accept(slot);
        }
        if (this.owner != null) {
            this.owner.markNoUpdateSync();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack inserted = this.insertItemInternal(slot, stack, simulate);
        if (!simulate) {
            if (this.onChangedListener != null) {
                this.onChangedListener.accept(slot);
            }
            if (this.owner != null) {
                this.owner.markNoUpdateSync();
            }
        }
        return inserted;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            if (this.onChangedListener != null) {
                this.onChangedListener.accept(slot);
            }
            if (this.owner != null) {
                this.owner.markNoUpdateSync();
            }
        }
        return extracted;
    }

    public NBTTagCompound writeNBT() {
        ArrayList<ItemStack> stackSet = new ArrayList<ItemStack>();
        int[] stackSetIdxSet = new int[this.inventory.length];
        block0: for (int i = 0; i < this.inventory.length; ++i) {
            IItemHandlerImpl.SlotStackHolder holder = this.inventory[i];
            ItemStack itemStack = holder.itemStack;
            if (itemStack.func_190926_b()) {
                stackSetIdxSet[i] = -1;
                continue;
            }
            for (int stackSetIdx = 0; stackSetIdx < stackSet.size(); ++stackSetIdx) {
                ItemStack stackInSet = (ItemStack)stackSet.get(stackSetIdx);
                if (!ItemUtils.matchStacks((ItemStack)itemStack, (ItemStack)stackInSet)) continue;
                stackSetIdxSet[i] = stackSetIdx;
                continue block0;
            }
            stackSet.add(itemStack);
            stackSetIdxSet[i] = stackSet.size() - 1;
        }
        NBTTagList stackSetTag = new NBTTagList();
        NBTTagList invSetTag = new NBTTagList();
        for (ItemStack stack : stackSet) {
            NBTTagCompound stackTag = stack.func_77955_b(new NBTTagCompound());
            if (stack.func_190916_E() >= 127) {
                stackTag.func_74768_a("Count", stack.func_190916_E());
            }
            stackSetTag.func_74742_a((NBTBase)stackTag);
        }
        for (int setIdx : stackSetIdxSet) {
            invSetTag.func_74742_a((NBTBase)new NBTTagByte((byte)setIdx));
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("stackSet", (NBTBase)stackSetTag);
        nBTTagCompound.func_74782_a("invSet", (NBTBase)invSetTag);
        return nBTTagCompound;
    }

    public void readNBT(NBTTagCompound tag) {
        int i;
        NBTTagList stackSetTag = tag.func_150295_c("stackSet", 10);
        NBTTagList invSetTag = tag.func_150295_c("invSet", 1);
        ArrayList<ItemStack> stackSet = new ArrayList<ItemStack>();
        for (i = 0; i < stackSetTag.func_74745_c(); ++i) {
            NBTTagCompound stackTag = stackSetTag.func_150305_b(i);
            ItemStack stack = new ItemStack(stackTag);
            stack.func_190920_e(stackTag.func_74762_e("Count"));
            stackSet.add(stack);
        }
        this.inventory = new IItemHandlerImpl.SlotStackHolder[invSetTag.func_74745_c()];
        for (i = 0; i < invSetTag.func_74745_c(); ++i) {
            IItemHandlerImpl.SlotStackHolder holder = new IItemHandlerImpl.SlotStackHolder(i);
            byte setIdx = ((NBTPrimitive)invSetTag.func_179238_g(i)).func_150290_f();
            if (setIdx != -1) {
                holder.itemStack = ((ItemStack)stackSet.get(setIdx)).func_77946_l();
            }
            this.inventory[i] = holder;
        }
        this.updateInOutSlots();
        this.updateSlotLimits();
        if (this.onChangedListener != null) {
            this.onChangedListener.accept(-1);
        }
    }
}

