/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;

public class StringUtils {
    public static List<String> sortWithMatchRate(Collection<String> source, String filter) {
        PriorityQueue<MatchResult> sorted = new PriorityQueue<MatchResult>();
        char[] filterCharArr = filter.replace(" ", "").toLowerCase().toCharArray();
        for (String s : source) {
            String str = s.replace(" ", "").toLowerCase();
            char[] targetCharArr = str.toCharArray();
            int matchRate = StringUtils.getMatchRate(filterCharArr, targetCharArr);
            if (matchRate <= 0) continue;
            sorted.add(new MatchResult(s, matchRate));
        }
        return sorted.stream().map(e -> ((MatchResult)e).str).collect(Collectors.toList());
    }

    private static int getMatchRate(char[] filterCharArr, char[] targetCharArr) {
        int matchRate = 0;
        int matchedCharCount = 0;
        int targetIndex = 0;
        block0: for (char c : filterCharArr) {
            for (int i = targetIndex; i < targetCharArr.length; ++i) {
                char tc = targetCharArr[i];
                if (c != tc) continue;
                matchRate += targetCharArr.length - targetIndex + 1;
                ++targetIndex;
                ++matchedCharCount;
                continue block0;
            }
        }
        if (targetCharArr.length >= filterCharArr.length && matchedCharCount == filterCharArr.length) {
            return Integer.MAX_VALUE;
        }
        return matchRate;
    }

    public static class MatchResult
    implements Comparable<MatchResult> {
        private final String str;
        private final int matchRate;

        public MatchResult(String str, int matchRate) {
            this.str = str;
            this.matchRate = matchRate;
        }

        @Override
        public int compareTo(MatchResult o) {
            return Integer.compare(o.matchRate, this.matchRate);
        }
    }
}

