/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MachineCoolants {
    public static final MachineCoolants INSTANCE = new MachineCoolants();
    private final Map<Fluid, Coolant> coolants = new Reference2ObjectLinkedOpenHashMap();

    public void init() {
        Fluid cryotheum;
        Fluid ice;
        Fluid water = FluidRegistry.getFluid((String)"water");
        Fluid steam = FluidRegistry.getFluid((String)"steam");
        if (steam != null) {
            this.coolants.put(water, new Coolant(new FluidStack(water, 1), new FluidStack(steam, 1), 15));
        }
        if ((ice = FluidRegistry.getFluid((String)"ice")) != null) {
            this.coolants.put(ice, new Coolant(new FluidStack(ice, 1), new FluidStack(water, 1), 30));
        }
        Fluid ic2Coolant = FluidRegistry.getFluid((String)"ic2coolant");
        Fluid ic2HotCoolant = FluidRegistry.getFluid((String)"ic2hot_coolant");
        if (ic2Coolant != null && ic2HotCoolant != null) {
            this.coolants.put(ic2Coolant, new Coolant(new FluidStack(ic2Coolant, 1), new FluidStack(ic2HotCoolant, 1), 90));
        }
        Fluid liquidHelium = FluidRegistry.getFluid((String)"liquid_helium");
        Fluid helium = FluidRegistry.getFluid((String)"helium");
        if (liquidHelium != null) {
            this.coolants.put(liquidHelium, new Coolant(new FluidStack(liquidHelium, 1), new FluidStack(helium, 320), 170));
        }
        Fluid liquidNitrogen = FluidRegistry.getFluid((String)"liquid_nitrogen");
        Fluid nitrogen = FluidRegistry.getFluid((String)"nitrogen");
        if (liquidNitrogen != null) {
            this.coolants.put(liquidNitrogen, new Coolant(new FluidStack(liquidNitrogen, 1), new FluidStack(nitrogen, 320), 190));
        }
        if ((cryotheum = FluidRegistry.getFluid((String)"cryotheum")) != null) {
            this.coolants.put(cryotheum, new Coolant(new FluidStack(cryotheum, 1), null, 240));
        }
    }

    public Collection<Coolant> getCoolants() {
        return this.coolants.values();
    }

    public Coolant getCoolant(Fluid fluid) {
        return this.coolants.get(fluid);
    }

    public static final class Coolant {
        private final FluidStack input;
        @Nullable
        private final FluidStack output;
        private final int coolantUnit;

        public Coolant(FluidStack input, @Nullable FluidStack output, int coolantUnit) {
            this.input = input;
            this.output = output;
            this.coolantUnit = coolantUnit;
        }

        public int maxCanConsume(IFluidHandler inputHandler, IFluidHandler outputHandler) {
            FluidStack drained = inputHandler.drain(new FluidStack(this.input.getFluid(), Integer.MAX_VALUE), false);
            if (drained == null) {
                return 0;
            }
            int filled = Integer.MAX_VALUE;
            if (this.output != null) {
                filled = outputHandler.fill(new FluidStack(this.output.getFluid(), drained.amount), false);
            }
            int inputMul = drained.amount / this.input.amount;
            if (this.output == null) {
                return inputMul;
            }
            int outputMul = filled / this.output.amount;
            return Math.min(inputMul, outputMul);
        }

        public int maxCanConsume(int inputStored, int outputCap, FluidStack outputStack) {
            int inputMul = inputStored / this.input.amount;
            if (this.output == null) {
                return inputMul;
            }
            if (outputStack == null) {
                int outputMul = outputCap / this.output.amount;
                return Math.min(inputMul, outputMul);
            }
            if (outputStack.getFluid() != this.output.getFluid()) {
                return 0;
            }
            return Math.min(inputMul, (outputCap - outputStack.amount) / this.output.amount);
        }

        public String toString() {
            return "Coolant[" + "input=" + this.input + "," + "output=" + this.output + "," + "coolantUnit=" + this.coolantUnit + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + this.coolantUnit;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Coolant)arg0).input, this.input)) {
                return false;
            }
            if (!Objects.equals(((Coolant)arg0).output, this.output)) {
                return false;
            }
            return ((Coolant)arg0).coolantUnit == this.coolantUnit;
            {
            }
        }

        public FluidStack input() {
            return this.input;
        }

        @Nullable
        public FluidStack output() {
            return this.output;
        }

        public int coolantUnit() {
            return this.coolantUnit;
        }
    }
}

