/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import github.kasuminova.novaeng.common.tile.ecotech.EPart;
import github.kasuminova.novaeng.common.tile.ecotech.EPartController;
import github.kasuminova.novaeng.common.util.ClassUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EPartMap<P extends EPart<?>> {
    protected final Map<Class<?>, List<P>> parts = new Reference2ObjectOpenHashMap();

    public P addPart(P part) {
        this.parts.computeIfAbsent(part.getClass(), k -> new ObjectArrayList()).add(part);
        ClassUtils.getAllSuperClasses(part.getClass(), EPart.class).stream().map(clazz -> this.parts.computeIfAbsent((Class<?>)clazz, k -> new ObjectArrayList())).forEach(partList -> partList.add(part));
        return part;
    }

    public <R extends P> List<R> getParts(Class<R> partClass) {
        return (List)this.parts.getOrDefault(partClass, (List<P>)new ObjectArrayList());
    }

    public void forEachPart(Consumer<P> consumer) {
        this.parts.values().stream().flatMap(Collection::stream).forEach(consumer);
    }

    public void assemble(EPartController<P> controller) {
        this.forEachPart(part -> {
            part.setController(controller);
            part.onAssembled();
        });
    }

    public void disassemble() {
        this.forEachPart(part -> {
            part.onDisassembled();
            part.setController(null);
        });
        this.parts.clear();
    }

    public void clear() {
        this.forEachPart(part -> part.setController(null));
        this.parts.clear();
    }
}

