/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import java.awt.Color;

public class ColorUtils {
    public static Color getGradientColor(Color[] colors, int alpha, float percentage) {
        float percent = Math.max(0.0f, Math.min(1.0f, percentage));
        if (colors.length < 2) {
            throw new IllegalArgumentException("Colors array must contain at least two colors.");
        }
        int numSegments = colors.length - 1;
        float segmentPercent = percent * (float)numSegments;
        int segmentIndex = (int)segmentPercent;
        if (segmentIndex >= numSegments) {
            return colors[numSegments];
        }
        if (segmentIndex < 0) {
            return colors[0];
        }
        Color startColor = colors[segmentIndex];
        Color endColor = colors[segmentIndex + 1];
        float segmentPercentage = segmentPercent - (float)segmentIndex;
        int interpolatedRed = (int)((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * segmentPercentage);
        int interpolatedGreen = (int)((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * segmentPercentage);
        int interpolatedBlue = (int)((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * segmentPercentage);
        return new Color(interpolatedRed, interpolatedGreen, interpolatedBlue, alpha);
    }
}

