/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ClassUtils {
    private static final Map<Class<?>, Set<Class<?>>> CLASS_INTERFACES_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<Class<?>>> CLASS_SUPERCLASSES_CACHE = new ConcurrentHashMap();

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        return CLASS_INTERFACES_CACHE.computeIfAbsent(clazz, key -> ClassUtils.getAllInterfaces(clazz, new ReferenceOpenHashSet()));
    }

    public static Set<Class<?>> getAllSuperClasses(Class<?> clazz, @Nullable Class<?> topClass) {
        return CLASS_SUPERCLASSES_CACHE.computeIfAbsent(clazz, key -> ClassUtils.getAllSuperClasses(clazz, topClass, new ReferenceOpenHashSet()));
    }

    protected static Set<Class<?>> getAllInterfaces(Class<?> clazz, Set<Class<?>> interfaceSet) {
        interfaceSet.addAll(Arrays.asList(clazz.getInterfaces()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ClassUtils.getAllInterfaces(superClass, interfaceSet);
        }
        return interfaceSet;
    }

    protected static Set<Class<?>> getAllSuperClasses(Class<?> clazz, @Nullable Class<?> topClass, Set<Class<?>> superClasses) {
        boolean topClassIsInterface = topClass != null && topClass.isInterface();
        Class<?> superClass = clazz.getSuperclass();
        if (!(superClass == null || topClassIsInterface && superClass == topClass)) {
            if (topClassIsInterface && ClassUtils.getAllInterfaces(superClass).contains(topClass)) {
                return superClasses;
            }
            superClasses.add(superClass);
            ClassUtils.getAllSuperClasses(superClass, topClass, superClasses);
        }
        return superClasses;
    }
}

