/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import io.netty.buffer.ByteBuf;

public class ByteBufUtils {
    private static final short SHORT = 254;
    private static final short INT = 253;
    private static final short LONG = 252;
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int USHORT_MAX = 65535;
    private static final short UBYTE_MAX = 251;

    public static void writeVarLong(ByteBuf buf, long value) {
        if (value > 0xFFFFFFFFL) {
            ByteBufUtils.writeUnsignedByte(buf, (short)252);
            buf.writeLong(value);
            return;
        }
        if (value > 65535L) {
            ByteBufUtils.writeUnsignedByte(buf, (short)253);
            ByteBufUtils.writeUnsignedInt(buf, value);
            return;
        }
        if (value > 251L) {
            ByteBufUtils.writeUnsignedByte(buf, (short)254);
            ByteBufUtils.writeUnsignedShort(buf, (int)value);
            return;
        }
        ByteBufUtils.writeUnsignedByte(buf, (short)value);
    }

    public static long readVarLong(ByteBuf buf) {
        long l;
        short type = buf.readUnsignedByte();
        switch (type) {
            case 254: {
                l = buf.readUnsignedShort();
                break;
            }
            case 253: {
                l = buf.readUnsignedInt();
                break;
            }
            case 252: {
                l = buf.readLong();
                break;
            }
            default: {
                l = type;
            }
        }
        return l;
    }

    public static void writeUnsignedByte(ByteBuf buf, short value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value out of range for unsigned byte: " + value);
        }
        buf.writeByte((int)((byte)value));
    }

    public static void writeUnsignedShort(ByteBuf buf, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value out of range for unsigned short: " + value);
        }
        buf.writeShort((int)((short)value));
    }

    public static void writeUnsignedInt(ByteBuf buf, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value out of range for unsigned int: " + value);
        }
        buf.writeInt((int)value);
    }
}

