/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.util;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;

public class AEItemStackSet {
    private final Map<Entry, Entry> entries = new Object2ObjectOpenHashMap();
    private final List<Entry> entryList = new ObjectArrayList();

    public int add(IAEItemStack stack) {
        Entry entry = this.entries.get(new Entry(stack, -1));
        if (entry == null) {
            entry = new Entry((IAEItemStack)stack.copy().setStackSize(1L), this.entryList.size());
            this.entries.put(entry, entry);
            this.entryList.add(entry);
        }
        return entry.id();
    }

    protected void addInternal(IAEItemStack stack) {
        Entry entry = new Entry(stack, this.entryList.size());
        this.entryList.add(entry);
        this.entries.put(entry, entry);
    }

    public IAEItemStack get(int id) {
        return this.entryList.get(id).stack().copy();
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeInt(this.entryList.size());
        for (Entry entry : this.entryList) {
            try {
                entry.stack().writeToPacket(buf);
            }
            catch (Throwable throwable) {}
        }
    }

    public void fromBuffer(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.addInternal((IAEItemStack)AEItemStack.fromPacket((ByteBuf)buf));
        }
    }

    private static final class Entry {
        private final IAEItemStack stack;
        private final int id;

        private Entry(IAEItemStack stack, int id) {
            this.stack = stack;
            this.id = id;
        }

        public int hashCode() {
            return this.stack.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.stack.equals(entry.stack);
        }

        public String toString() {
            return "Entry[" + "stack=" + this.stack + "," + "id=" + this.id + "]";
        }

        public IAEItemStack stack() {
            return this.stack;
        }

        public int id() {
            return this.id;
        }
    }
}

